package com.ejianc.business.supbid.rent.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.supbid.rent.bean.RentSchemeRecordEntity;
import com.ejianc.business.supbid.rent.vo.RentSchemeRecordVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.supbid.rent.mapper.RentSchemeRecordMapper;
import com.ejianc.business.supbid.rent.bean.RentSchemeRecordEntity;
import com.ejianc.business.supbid.rent.service.IRentSchemeRecordService;

import java.util.ArrayList;
import java.util.List;

/**
 * 设备租赁洽商谈判方案记录表
 * 
 * @author generator
 * 
 */
@Service("rentSchemeRecordService")
public class RentSchemeRecordServiceImpl extends BaseServiceImpl<RentSchemeRecordMapper, RentSchemeRecordEntity> implements IRentSchemeRecordService{
    @Override
    public List<RentSchemeRecordVO> queryListbySourceId(Long noticeId) {
        List<RentSchemeRecordVO> res = new ArrayList<>();
        List<RentSchemeRecordEntity> rentSchemeRecordEntityList = super
                .list(Wrappers.<RentSchemeRecordEntity>lambdaQuery()
                        .eq(RentSchemeRecordEntity::getNoticeId, noticeId)
                        .eq(RentSchemeRecordEntity::getTenantId, InvocationInfoProxy.getTenantid())
                        .orderByAsc(RentSchemeRecordEntity::getSchemeName));
        if (CollectionUtils.isNotEmpty(rentSchemeRecordEntityList)) {
            rentSchemeRecordEntityList.forEach(e -> {
                RentSchemeRecordEntity rentSchemeRecordEntity = super.selectById(e.getId());
                res.add(BeanMapper.map(rentSchemeRecordEntity, RentSchemeRecordVO.class));
            });
        }
        return res;
    }
}
