package com.ejianc.business.supbid.win.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.supbid.win.vo.BidVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.supbid.win.bean.BidEntity;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;

/**
 * 中标通知书表
 *
 * @author generator
 */
public interface IBidService extends IBaseService<BidEntity> {

    /**
     * 保存中标通知书
     *
     * @param request 请求信息
     * @param file    文件信息
     * @return 保存结果
     */
    boolean saveBid(HttpServletRequest request, MultipartFile file);

    /**
     * 查询中标通知书列表
     *
     * @param param 查询参数
     * @return 查询结果
     */
    IPage<BidVO> queryBidList(QueryParam param);
}
