/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbid.notice.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supbid.notice.bean.SignEntity;
import com.ejianc.business.supbid.notice.service.ISignService;
import com.ejianc.business.supbid.notice.vo.SignVO;
import com.ejianc.business.supbid.notice.vo.SubleadersVO;
import com.ejianc.business.supbid.notice.vo.SupOfferVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"sign"})
@Api(value="\u62a5\u540d\u5b9e\u4f53", tags={"\u62a5\u540d\u5b9e\u4f53"})
public class SignController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISignService service;
    @Autowired
    private ISystemDataPushService systemDataPushService;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SignVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody SignVO saveorUpdateVO) throws Exception {
        return this.service.save(saveorUpdateVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SignVO> queryDetail(@RequestParam Long id) {
        SignEntity entity = (SignEntity)((Object)this.service.selectById(id));
        SignVO vo = (SignVO)BeanMapper.map((Object)((Object)entity), SignVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u6dd8\u6c70\u63a5\u53e3")
    @RequestMapping(value={"/updateSupStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> updateSupStatus(@RequestBody List<SignVO> signVOList) {
        return CommonResponse.success((String)"\u6210\u529f\uff01", (Object)this.service.updateSignStatus(signVOList));
    }

    @ApiOperation(value="\u6d41\u6807/\u5e9f\u6807 \u4f9b\u5e94\u5546\u6dd8\u6c70\u63a5\u53e3")
    @RequestMapping(value={"/updateBidOut"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> updateBidOut(@RequestBody SupOfferVO supOfferVO) {
        return CommonResponse.success((String)"\u6210\u529f\uff01", (Object)this.service.updateBidOut(supOfferVO.getSourceId(), supOfferVO.getType(), supOfferVO.getOutReason()));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SignVO> vos) {
        this.service.removeByIds(vos.stream().map(SignVO::getsId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SignVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SignVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Sign-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refSignData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SignVO>> refSignData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SignVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ResponseBody
    @RequestMapping(value={"/queryCategory"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> queryCategory(@RequestParam(value="categoryProperty") String categoryProperty) {
        ArrayList<JSONObject> listReturn;
        String url = "/ejc-share-web/openapi/api/shareSubleadersApi/querySupplierByLeaderId";
        Map files = null;
        JSONObject jsonObjectReturn = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("leaderTenantId", categoryProperty);
        CommonResponse commonResponse = this.systemDataPushService.exchangeDataAndFilesWithThirdSystem(url, params, "523927879856832602", files);
        if (commonResponse.getCode() == 0) {
            JSONObject jsonObject = JSONObject.parseObject((String)((String)commonResponse.getData()));
            String data = jsonObject.getString("data");
            List list = JSON.parseArray((String)data, SubleadersVO.class);
            listReturn = new ArrayList<JSONObject>();
            for (SubleadersVO subleadersVO : list) {
                JSONObject o = new JSONObject();
                o.put("text", (Object)subleadersVO.getSupplierName());
                o.put("value", (Object)subleadersVO.getId());
                listReturn.add(o);
            }
        } else {
            jsonObjectReturn.put("data", null);
            return CommonResponse.success((Object)jsonObjectReturn);
        }
        jsonObjectReturn.put("data", listReturn);
        return CommonResponse.success((Object)jsonObjectReturn);
    }
}

