/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbid.win.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supbid.notice.bean.SignEntity;
import com.ejianc.business.supbid.notice.service.ISignService;
import com.ejianc.business.supbid.util.DateUtils;
import com.ejianc.business.supbid.util.SendMsgUtils;
import com.ejianc.business.supbid.win.bean.WinDetailEntity;
import com.ejianc.business.supbid.win.bean.WinEntity;
import com.ejianc.business.supbid.win.mapper.WinMapper;
import com.ejianc.business.supbid.win.service.IWinService;
import com.ejianc.business.supbid.win.vo.WinVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="winService")
public class WinServiceImpl
extends BaseServiceImpl<WinMapper, WinEntity>
implements IWinService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;
    @Autowired
    private ISignService signService;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IPushMessageApi pushMessageApi;
    private String WEIXIN_TENDER_MSG_INVITATION = "zPmNzDvvFsai2naZFVEuODPWzwgeigu25dsDUvz7kT8";
    private static final Integer PURCHASE_TYPE_1 = 1;

    @Override
    public boolean saveWin(WinVO saveOrUpdateVO) {
        this.logger.info("\u63a5\u6536\u4e2d\u6807\u516c\u544a\uff0csourceID->[{}]", (Object)saveOrUpdateVO.getSourceId());
        WinEntity entity = (WinEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, WinEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            QueryParam param = new QueryParam();
            param.getParams().put("sourceId", new Parameter("eq", (Object)entity.getSourceId()));
            List winEntityList = super.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)winEntityList)) {
                entity.setId(((WinEntity)((Object)winEntityList.get(0))).getId());
            }
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("sourceId", new Parameter("eq", (Object)saveOrUpdateVO.getSourceId()));
            List signEntityList = this.signService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)signEntityList)) {
                this.logger.info("\u4f9b\u5e94\u5546\u6570\u91cf\u3010{}\u3011", (Object)signEntityList.size());
                for (SignEntity sign : signEntityList) {
                    ArrayList<String> userList = new ArrayList<String>();
                    if (sign.getSignId() != null) {
                        userList.add(sign.getSignId().toString());
                    }
                    if (sign.getSchemeId() != null) {
                        userList.add(sign.getSchemeId().toString());
                    }
                    try {
                        userList = userList.stream().distinct().collect(Collectors.toList());
                        this.sendWeChatMsgByMap(userList, 1, this.WEIXIN_TENDER_MSG_INVITATION, entity, sign);
                    }
                    catch (Exception e) {
                        this.logger.info("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)e.getMessage(), (Object)e);
                    }
                }
            }
        }
        return super.saveOrUpdate((Object)entity, false);
    }

    private void sendWeChatMsgByMap(List<String> userList, Integer tenderType, String weixinCheckTemplateId, WinEntity winEntity, SignEntity signEntity) {
        if (CollectionUtils.isEmpty(userList)) {
            this.logger.info("\u67e5\u8be2\u4fe1\u606f\u4e3a\u7a7a\uff01");
            return;
        }
        this.logger.info("------\u5f00\u59cb\u53d1\u9001\u5fae\u4fe1\u6d88\u606f----");
        this.logger.info("\u53d1\u9001\u6d88\u606f\u6570\u91cf\uff1a{}\uff1b\u53d1\u9001\u6d88\u606f\u7c7b\u578b\uff081\u516c\u5f00\uff0c2\u9080\u8bf7\uff09\uff1a{}\uff1b\u6d88\u606f\u6a21\u677f\uff1a{}", new Object[]{userList.size(), tenderType, weixinCheckTemplateId});
        if (CollectionUtils.isNotEmpty(userList)) {
            HashMap<String, Object> weixinMap = new HashMap<String, Object>();
            List<WinDetailEntity> winDetailList = winEntity.getWinDetailList();
            StringBuffer supplierNames = new StringBuffer();
            for (int i = 0; i < winDetailList.size(); ++i) {
                if (i == winDetailList.size() - 1) {
                    supplierNames.append(winDetailList.get(i).getSupplierName());
                    continue;
                }
                supplierNames.append(winDetailList.get(i).getSupplierName() + ",");
            }
            String winDate = DateUtils.transformationDate(winEntity.getWinDate(), "yyyy-MM-dd HH:mm:ss");
            String formurl = "";
            String subject = "\u60a8\u597d\uff0c\u60a8\u53c2\u4e0e\u7684\u7adf\u4ef7\u9879\u76ee\u7ed3\u679c\u5df2\u7ecf\u516c\u5e03";
            String content = "\u60a8\u597d\uff0c\u60a8\u53c2\u4e0e\u7684\u7adf\u4ef7\u9879\u76ee\u7ed3\u679c\u5df2\u7ecf\u516c\u5e03";
            String mobileUrl = this.BASE_HOST + "ejc-supbid-mobile/#/bidWinning?openid={openid}";
            weixinMap.put("first", "\u60a8\u597d\uff0c\u60a8\u53c2\u4e0e\u7684\u7adf\u4ef7\u9879\u76ee\u7ed3\u679c\u5df2\u7ecf\u516c\u5e03");
            weixinMap.put("keyword1", winEntity.getTenderName());
            weixinMap.put("keyword2", winDate);
            weixinMap.put("remark", "\u7531 \u3010" + supplierNames + "\u3011\u4e2d\u6807\uff0c\u70b9\u51fb\u67e5\u770b\u8be6\u60c5");
            new SendMsgUtils().sendWeiXinMsg(userList, subject, content, signEntity.getTenantId().toString(), weixinMap, weixinCheckTemplateId, mobileUrl, this.pushMessageApi);
        }
        this.logger.info("------\u53d1\u9001\u5fae\u4fe1\u6d88\u606f\u7ed3\u675f----");
    }

    @Override
    public IPage<WinVO> queryWinList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("winTitle");
        fuzzyFields.add("unitName");
        ArrayList<Integer> tenderTypeList = new ArrayList<Integer>();
        tenderTypeList.add(0);
        tenderTypeList.add(2);
        CommonResponse response = this.cooperateEnterpriseApi.getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        if (!response.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)response.getMsg());
            throw new BusinessException("\u83b7\u53d6\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25");
        }
        List systemIdList = (List)response.getData();
        this.logger.info("\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\uff1a{}", (Object)systemIdList);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        if (CollectionUtils.isNotEmpty((Collection)systemIdList)) {
            List<WinVO> winVOList = ((WinMapper)this.baseMapper).queryWinList((QueryWrapper<WinEntity>)WinServiceImpl.changeToQueryWrapper((QueryParam)param), tenderTypeList, String.valueOf(InvocationInfoProxy.getTenantid()), systemIdList, (IPage<WinEntity>)page);
            Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(winVOList);
            return pageData;
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        return pageData;
    }

    @Override
    public WinVO queryWinDetail(Long id) {
        WinEntity entity = (WinEntity)((Object)super.selectById((Serializable)id));
        if (entity == null) {
            return new WinVO();
        }
        WinVO vo = (WinVO)BeanMapper.map((Object)((Object)entity), WinVO.class);
        vo.setTypeName(this.getTypeName(vo.getType()));
        return vo;
    }

    private String getTypeName(String type) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        switch (type) {
            case "MATERIAL": {
                return "\u6750\u6599\u62db\u6807";
            }
            case "SUB": {
                return "\u5206\u5305\u62db\u6807";
            }
            case "PURCHASE": {
                return "\u8bbe\u5907\u91c7\u8d2d\u62db\u6807";
            }
            case "RENT": {
                return "\u8bbe\u5907\u79df\u8d41\u62db\u6807";
            }
            case "RMAT": {
                return "\u5468\u8f6c\u6750\u79df\u8d41\u62db\u6807";
            }
            case "OTHER": {
                return "\u5176\u4ed6\u62db\u6807";
            }
        }
        return null;
    }
}

