package com.ejianc.business.supbid.other.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 其他方案实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_supbid_other_scheme")
public class OtherSchemeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="notice_id")
    private Long noticeId; // 主表主键
    @TableField(value="source_id")
    private String sourceId; // 招标信息主键
    @TableField(value="scheme_name")
    private String schemeName; // 方案名称
    @TableField(value="money")
    private BigDecimal money; // 报价总额
    @TableField(value="money_tax")
    private BigDecimal moneyTax; // 报价总额(含税)

    @TableField(exist=false)
    @SubEntity(serviceName="otherSchemeDetailService", pidName = "schemeId")//此处有pid="xxx"，默认值pid="pid"
    private List<OtherSchemeDetailEntity> otherSchemeDetailList = new ArrayList<>(); // 设备采购报价明细
    

    public Long getNoticeId() {
        return noticeId;
    }

    public void setNoticeId(Long noticeId) {
        this.noticeId = noticeId;
    }
    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    public String getSchemeName() {
        return schemeName;
    }

    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }
    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    public BigDecimal getMoneyTax() {
        return moneyTax;
    }

    public void setMoneyTax(BigDecimal moneyTax) {
        this.moneyTax = moneyTax;
    }

    public List<OtherSchemeDetailEntity> getOtherSchemeDetailList() {
        return otherSchemeDetailList;
    }

    public void setOtherSchemeDetailList(List<OtherSchemeDetailEntity> otherSchemeDetailList) {
        this.otherSchemeDetailList = otherSchemeDetailList;
    }
}
