package com.ejianc.business.supbid.win.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supbid.util.CommonUtils;
import com.ejianc.business.supbid.util.SupbidFileUtils;
import com.ejianc.business.supbid.win.vo.BidVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.supbid.win.mapper.BidMapper;
import com.ejianc.business.supbid.win.bean.BidEntity;
import com.ejianc.business.supbid.win.service.IBidService;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 中标通知书表
 *
 * @author generator
 */
@Service("bidService")
public class BidServiceImpl extends BaseServiceImpl<BidMapper, BidEntity> implements IBidService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    private static final String BILL_TYPE = "BT220311000000001";
    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;

    /**
     * 保存中标通知书
     *
     * @param request 请求信息
     * @param file    文件信息
     * @return 保存结果
     */
    @Override
    public boolean saveBid(HttpServletRequest request, MultipartFile file) {
        logger.info("--------------进入中标通知书接收接口-------------------");
        logger.info("request--" + request);
        String bid = request.getParameter("transData");
        logger.info("bid实体信息--" + bid);
        BidVO bidVO = JSON.parseObject(bid, new TypeReference<BidVO>() {
        });
        if (null == bidVO.getSystemId()) {
            throw new BusinessException("系统来源为空！");
        }
        BidEntity bidEntity = BeanMapper.map(bidVO, BidEntity.class);
        if (file == null) {
            throw new BusinessException("中标通知书为空！");
        }
        super.saveOrUpdate(bidEntity, false);
        logger.info(request + "文件模板--" + file.getOriginalFilename());
        AttachmentVO attachmentVO = SupbidFileUtils
                .upFile("bidFiles", Long.toString(bidEntity.getId()), BILL_TYPE, file, request, BASE_HOST, logger);
        if (attachmentVO == null) {
            throw new BusinessException("中标通知书上传失败！");
        }
        bidEntity.setBidFileId(attachmentVO.getId());
        boolean flag = super.saveOrUpdate(bidEntity, false);
        logger.info("--------------中标通知书接收接口结束-------------------");
        return flag;
    }

    /**
     * 查询中标通知书列表
     *
     * @param param 查询参数
     * @return 查询结果
     */
    @Override
    public IPage<BidVO> queryBidList(QueryParam param) {
        // 模糊搜索配置字段示例
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bidTitle");
        fuzzyFields.add("unitName");
        // 租户隔离
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        // 查询合作企业的systemId
//        CommonResponse<List<String>> response = cooperateEnterpriseApi
//                .getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
//        if (!response.isSuccess()) {
//            logger.error("获取合作企业信息失败！失败原因：{}", response.getMsg());
//            throw new BusinessException("获取合作企业信息失败");
//        }
//        List<String> systemIdList = response.getData();
//        logger.info("合作企业信息：{}", systemIdList);
//        param.getParams().put("systemId", new Parameter(QueryParam.IN, systemIdList));
        param.getOrderMap().put("bidDate",QueryParam.DESC);
        IPage<BidEntity> page = super.queryPage(param, false);
        IPage<BidVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<BidVO> bidVOList = BeanMapper.mapList(page.getRecords(), BidVO.class);
        // 字段转义
        for (BidVO bidVO : bidVOList) {
            bidVO.setTypeName(CommonUtils.getTypeName(bidVO.getType()));
        }
        pageData.setRecords(bidVOList);
        return pageData;
    }
}
