package com.ejianc.business.supbid.winbid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supbid.notice.bean.NoticeEntity;
import com.ejianc.business.supbid.notice.bean.SignEntity;
import com.ejianc.business.supbid.notice.service.INoticeService;
import com.ejianc.business.supbid.notice.service.ISignService;
import com.ejianc.business.supbid.rmat.bean.RmatSchemeRepairEntity;
import com.ejianc.business.supbid.rmat.bean.RmatSchemeScrapEntity;
import com.ejianc.business.supbid.rmat.service.IRmatSchemeRepairService;
import com.ejianc.business.supbid.rmat.service.IRmatSchemeScrapService;
import com.ejianc.business.supbid.rmat.vo.RmatSchemeRepairVO;
import com.ejianc.business.supbid.rmat.vo.RmatSchemeScrapVO;
import com.ejianc.business.supbid.util.CommonUtils;
import com.ejianc.business.supbid.util.SendMsgUtils;
import com.ejianc.business.supbid.winbid.bean.*;
import com.ejianc.business.supbid.winbid.service.*;
import com.ejianc.business.supbid.winbid.vo.WinbidVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.google.gson.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.supbid.winbid.mapper.WinbidMapper;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 中标实体
 *
 * @author generator
 */
@Service("winbidService")
public class WinbidServiceImpl extends BaseServiceImpl<WinbidMapper, WinbidEntity> implements IWinbidService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    /**
     * 采购方式：1-单位采购
     */
    private static final Integer PURCHASE_TYPE_1 = 1;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private ISignService signService;

    /** 材料 */
    @Autowired
    private IWinbidDetailService winbidDetailService;
    /** 分包 */
    @Autowired
    private ISubWinbidDetailService subWinbidDetailService;
    /** 设备 */
    @Autowired
    private IPurchaseWinbidDetailService purchaseWinbidDetailService;
    /** 设备租赁 */
    @Autowired
    private IRentWinbidDetailService rentWinbidDetailService;
    /** 周转材租赁 */
    @Autowired
    private IRmatWinbidDetailService rmatWinbidDetailService;
    /** 其他 */
    @Autowired
    private IOtherWinbidDetailService otherWinbidDetailService;

    @Autowired
    private IWinbidContentService winbidContentService;

    @Autowired
    private INoticeService noticeService;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;

    @Autowired
    private IRmatSchemeRepairService rmatSchemeRepairService;

    @Autowired
    private IRmatSchemeScrapService rmatSchemeScrapService;


    @Override
    public WinbidVO queryWinbidDetail(String sourceId) {
        List<WinbidEntity> list = super
                .list(Wrappers.<WinbidEntity>lambdaQuery().eq(WinbidEntity::getSourceId, sourceId)
                        .eq(WinbidEntity::getTenantId, InvocationInfoProxy.getTenantid()));
        if (CollectionUtils.isNotEmpty(list)) {
            WinbidEntity winbidEntity = list.get(0);
            // 材料招标
            if (CommonUtils.TYPE_MATERIAL.equals(winbidEntity.getType())) {
                List<WinbidDetailEntity> winbidEntityList = winbidDetailService
                        .list(Wrappers.<WinbidDetailEntity>lambdaQuery().eq(WinbidDetailEntity::getSourceId, sourceId)
                                .eq(WinbidDetailEntity::getTenantId, InvocationInfoProxy.getTenantid()));
                winbidEntity.setWinbidDetailList(winbidEntityList);
            }
            // 分包招标
            else if (CommonUtils.TYPE_SUB.equals(winbidEntity.getType())) {
                List<SubWinbidDetailEntity> subWinbidDetailEntityList = subWinbidDetailService
                        .list(Wrappers.<SubWinbidDetailEntity>lambdaQuery()
                                .eq(SubWinbidDetailEntity::getSourceId, sourceId)
                                .eq(SubWinbidDetailEntity::getTenantId, InvocationInfoProxy.getTenantid()));
                winbidEntity.setSubWinbidDetailList(subWinbidDetailEntityList);
            }
            // 设备采购
            else if (CommonUtils.TYPE_PURCHASE.equals(winbidEntity.getType())) {
                List<PurchaseWinbidDetailEntity> purchaseWinbidDetailEntityList = purchaseWinbidDetailService
                        .list(Wrappers.<PurchaseWinbidDetailEntity>lambdaQuery()
                                .eq(PurchaseWinbidDetailEntity::getSourceId, sourceId)
                                .eq(PurchaseWinbidDetailEntity::getTenantId, InvocationInfoProxy.getTenantid()));
                winbidEntity.setPurchaseWinbidDetailList(purchaseWinbidDetailEntityList);
            }
            // 设备租赁
            else if (CommonUtils.TYPE_RENT.equals(winbidEntity.getType())) {
                List<RentWinbidDetailEntity> rentWinbidDetailEntityList = rentWinbidDetailService
                        .list(Wrappers.<RentWinbidDetailEntity>lambdaQuery()
                                .eq(RentWinbidDetailEntity::getSourceId, sourceId)
                                .eq(RentWinbidDetailEntity::getTenantId, InvocationInfoProxy.getTenantid()));
                winbidEntity.setRentWinbidDetailList(rentWinbidDetailEntityList);
            }
            // 周转材租赁
            else if (CommonUtils.TYPE_RMAT.equals(winbidEntity.getType())) {
                List<RmatWinbidDetailEntity> rmatWinbidDetailEntityList = rmatWinbidDetailService
                        .list(Wrappers.<RmatWinbidDetailEntity>lambdaQuery()
                                .eq(RmatWinbidDetailEntity::getSourceId, sourceId)
                                .eq(RmatWinbidDetailEntity::getTenantId, InvocationInfoProxy.getTenantid()));
                winbidEntity.setRmatWinbidDetailList(rmatWinbidDetailEntityList);
            }
            // 其他
            else if (CommonUtils.TYPE_OTHER.equals(winbidEntity.getType())) {
                List<OtherWinbidDetailEntity> otherWinbidDetailEntityList = otherWinbidDetailService
                        .list(Wrappers.<OtherWinbidDetailEntity>lambdaQuery()
                                .eq(OtherWinbidDetailEntity::getSourceId, sourceId)
                                .eq(OtherWinbidDetailEntity::getTenantId, InvocationInfoProxy.getTenantid()));
                winbidEntity.setOtherWinbidDetailList(otherWinbidDetailEntityList);
            }
            else {
                logger.error("招标类型不存在[{}]", winbidEntity.getType());
                throw new BusinessException("招标类型不存在");
            }

            WinbidVO vo = BeanMapper.map(winbidEntity, WinbidVO.class);
            if (CommonUtils.TYPE_RMAT.equals(vo.getType())){
                //查询 维修/报废信息
                List<RmatSchemeRepairEntity> rmatSchemeRepairEntityList = rmatSchemeRepairService
                        .list((Wrappers.<RmatSchemeRepairEntity>lambdaQuery()
                                .eq(RmatSchemeRepairEntity::getSourceId, sourceId))
                                .eq(RmatSchemeRepairEntity::getTenantId, InvocationInfoProxy.getTenantid()));
                if (CollectionUtils.isNotEmpty(rmatSchemeRepairEntityList)) {
                    //说明之前报过价
                    vo.setRmatSchemeRepairList(BeanMapper.mapList(rmatSchemeRepairEntityList,RmatSchemeRepairVO.class));
                }else{
                    vo.setRmatSchemeRepairList(new ArrayList<>());
                }

                List<RmatSchemeScrapEntity> rmatSchemeScrapEntityList = rmatSchemeScrapService
                        .list((Wrappers.<RmatSchemeScrapEntity>lambdaQuery()
                                .eq(RmatSchemeScrapEntity::getNoticeId, sourceId))
                                .eq(RmatSchemeScrapEntity::getTenantId, InvocationInfoProxy.getTenantid()));
                if (CollectionUtils.isNotEmpty(rmatSchemeScrapEntityList)) {
                    vo.setRmatSchemeScrapList(BeanMapper.mapList(rmatSchemeScrapEntityList,RmatSchemeScrapVO.class));
                }else{
                    vo.setRmatSchemeScrapList(new ArrayList<>());
                }
            }
            if (CommonUtils.TYPE_RMAT.equals(vo.getType())||CommonUtils.TYPE_RENT.equals(vo.getType())){
                List<NoticeEntity> noticeEntities = noticeService
                        .list(Wrappers.<NoticeEntity>lambdaQuery().eq(NoticeEntity::getSourceId,sourceId));
                if(CollectionUtils.isNotEmpty(noticeEntities)){
                    vo.setRentType(noticeEntities.get(0).getRentType());
                }
            }
            WinbidContentEntity winbidContentEntity = winbidContentService
                    .getOne((Wrappers.<WinbidContentEntity>lambdaQuery()
                            .eq(WinbidContentEntity::getWinbidId, winbidEntity.getId())));
            if (null != winbidContentEntity) {
                vo.setContent(winbidContentEntity.getContent());
            }
            return vo;
        }
        else {
            return null;
        }
    }

    @Override
    public CommonResponse<Boolean> save(List<WinbidVO> listVO) {
        logger.info("接收到数据：{}", JSONObject.toJSONString(listVO));
        if (CollectionUtils.isNotEmpty(listVO)) {
            // 先查出已剔除的供应商
            QueryParam param = new QueryParam();
            param.getParams().put("sourceId", new Parameter(QueryParam.EQ, listVO.get(0).getSourceId()));
            param.getParams().put("signStatus", new Parameter(QueryParam.EQ, 5));
            List<SignEntity> outSignEntityList = signService.queryList(param);
            // 已剔除的供应商ID集合
            List<Long> outList = outSignEntityList.stream().map(SignEntity::getId).collect(Collectors.toList());
            listVO.forEach(e -> {
                WinbidEntity winbidEntity = BeanMapper.map(e, WinbidEntity.class);
                // 材料定标
                if (CommonUtils.TYPE_MATERIAL.equals(winbidEntity.getType())) {
                    if (CollectionUtils.isNotEmpty(winbidEntity.getWinbidDetailList())) {
                        winbidEntity.getWinbidDetailList().forEach(k -> {
                            k.setTenantId(winbidEntity.getTenantId());
                        });
                    }
                }
                // 分包定标
                else if (CommonUtils.TYPE_SUB.equals(winbidEntity.getType())) {
                    if (CollectionUtils.isNotEmpty(winbidEntity.getSubWinbidDetailList())) {
                        winbidEntity.getSubWinbidDetailList().forEach(k -> {
                            k.setTenantId(winbidEntity.getTenantId());
                        });
                    }
                }
                // 设备采购
                else if (CommonUtils.TYPE_PURCHASE.equals(winbidEntity.getType())) {
                    if (CollectionUtils.isNotEmpty(winbidEntity.getPurchaseWinbidDetailList())) {
                        winbidEntity.getPurchaseWinbidDetailList().forEach(k -> {
                            k.setTenantId(winbidEntity.getTenantId());
                        });
                    }
                }
                // 设备租赁
                else if (CommonUtils.TYPE_RENT.equals(winbidEntity.getType())) {
                    if (CollectionUtils.isNotEmpty(winbidEntity.getRentWinbidDetailList())) {
                        winbidEntity.getRentWinbidDetailList().forEach(k -> {
                            k.setTenantId(winbidEntity.getTenantId());
                        });
                    }
                }
                // 周转材租赁
                else if (CommonUtils.TYPE_RMAT.equals(winbidEntity.getType())) {
                    if (CollectionUtils.isNotEmpty(winbidEntity.getRmatWinbidDetailList())) {
                        winbidEntity.getRmatWinbidDetailList().forEach(k -> {
                            k.setTenantId(winbidEntity.getTenantId());
                        });
                    }
                }
                // 其他
                else if (CommonUtils.TYPE_OTHER.equals(winbidEntity.getType())) {
                    if (CollectionUtils.isNotEmpty(winbidEntity.getOtherWinbidDetailList())) {
                        winbidEntity.getOtherWinbidDetailList().forEach(k -> {
                            k.setTenantId(winbidEntity.getTenantId());
                        });
                    }
                }
                // 不存在
                else {
                    logger.error("招标类型不存在[{}]", winbidEntity.getType());
                    throw new BusinessException("招标类型不存在");
                }
                super.saveOrUpdate(winbidEntity, false);
                if (StringUtils.isNotEmpty(e.getContent())) {
                    WinbidContentEntity contentEntity = new WinbidContentEntity();
                    contentEntity.setWinbidId(winbidEntity.getId());
                    contentEntity.setContent(e.getContent());
                    contentEntity.setTenantId(winbidEntity.getTenantId());
                    winbidContentService.save(contentEntity);
                }
                if (null != e.getWinbidType() && 0 == e.getWinbidType()) {
                    //将对应报名表更新为已定标  剩下的改为已淘汰
                    LambdaUpdateWrapper<SignEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.eq(SignEntity::getSourceId, e.getSourceId());
                    updateWrapper.eq(SignEntity::getTenantId, e.getTenantId());//查询已报名
                    updateWrapper.set(SignEntity::getSignStatus, 4);//已定标
                    signService.update(updateWrapper);
                }
            });
            // 定标发送消息通知
            if (null != listVO.get(0).getWinbidType() && 0 == listVO.get(0).getWinbidType()) {
                LambdaUpdateWrapper<SignEntity> updateWrapper2 = new LambdaUpdateWrapper<>();
                updateWrapper2.eq(SignEntity::getSourceId, listVO.get(0).getSourceId());
                updateWrapper2.ne(SignEntity::getSignStatus, 4);//没用定标的全部改为淘汰
                updateWrapper2.set(SignEntity::getSignStatus, 5);//已淘汰
                updateWrapper2.set(SignEntity::getOutReason, "未中标");
                signService.update(updateWrapper2);
                // 发送内部消息
                // 查询所需信息
                logger.info("开始组织消息发送内容===========");
                QueryParam queryParam = new QueryParam();
                // 中标未中标的SourceId相同，取第一个SourceId
                queryParam.getParams().put("sourceId", new Parameter(QueryParam.EQ, listVO.get(0).getSourceId()));
                List<NoticeEntity> noticeEntityList = noticeService.queryList(queryParam);
                // 查询所有已淘汰的供应商
                queryParam.getParams().put("signStatus", new Parameter(QueryParam.EQ, 5));
                // 已剔除的供应商不发送消息
                if (CollectionUtils.isNotEmpty(outList)) {
                    queryParam.getParams().put("id", new Parameter(QueryParam.NOT_IN, outList));
                }
                List<SignEntity> signEntityList = signService.queryList(queryParam);
                if (CollectionUtils.isNotEmpty(signEntityList) && CollectionUtils.isNotEmpty(noticeEntityList)) {
                    logger.info("未中标供应商数量【{}】", signEntityList.size());
                    // 接收消息的user
                    List<String> userList;
                    for (SignEntity sign : signEntityList) {
                        userList = new ArrayList<>();
                        if (sign.getSignId() != null) userList.add(sign.getSignId().toString()); // 报名操作人
                        if (sign.getSchemeId() != null) userList.add(sign.getSchemeId().toString()); // 报价操作人
                        // 去重，防止一个人接收到多条相同的信息
                        userList = userList.stream().distinct().collect(Collectors.toList());
                        // 获取公告信息，公告信息只有一条
                        NoticeEntity noticeEntity = noticeEntityList.get(0);
                        String projectName = noticeEntity.getProjectName();
                        // 单位采购使用orgName
                        if (PURCHASE_TYPE_1.equals(noticeEntity.getPurchaseType())) {
                            projectName = noticeEntity.getOrgName();
                        }
                        // 组装标题及内容
                        String formurl = baseHost + "ejc-supbid-frontend/#/eliminated?id=" + noticeEntity.getId();
                        String mobileurl = baseHost + "ejc-supbid-mobile/#/inProgressList/eliminated?id=" + noticeEntity.getId();
                        String subject = "很遗憾,你投标的【" + projectName + "】未中标，感谢您的参与！";
                        String content = "很遗憾,你投标的【" + projectName + "】未中标，感谢您的参与！" +
                                "<a href= '" + formurl + "'" + ">点击查看详情</a>";
                        new SendMsgUtils().sendSysMsg(userList, subject, content, sign.getTenantId(), pushMessageApi,mobileurl);
                    }
                }
            }
        }
        return CommonResponse.success("操作成功！", true);
    }

    /**
     * 查询门户流标/废标列表
     *
     * @param param 查询参数
     * @return 查询结果
     */
    @Override
    public IPage<WinbidVO> queryHomeList(QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
//        fuzzyFields.add("employeeName");
//        fuzzyFields.add("employeeMobile");
//        fuzzyFields.add("unitName");
        fuzzyFields.add("tenderName"); // 标题
        fuzzyFields.add("memo"); // 原因

        // 查询合作企业的systemId
        CommonResponse<List<String>> response = cooperateEnterpriseApi
                .getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        if (!response.isSuccess()) {
            logger.error("获取合作企业信息失败！失败原因：{}", response.getMsg());
            throw new BusinessException("获取合作企业信息失败");
        }
        List<String> systemIdList = response.getData();
        if(CollectionUtils.isNotEmpty(systemIdList)){
            param.getParams().put("systemId", new Parameter(QueryParam.IN, systemIdList));
        }else{
            param.getParams().put("systemId", new Parameter(QueryParam.EQ, -1l));
        }
        // 非0的列表
//        param.getParams().put("winbidType", new Parameter(QueryParam.NE, 0));
        IPage<WinbidEntity> page = super.queryPage(param, false);
        IPage<WinbidVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WinbidVO.class));
        return pageData;
    }
}
