package com.ejianc.business.supplier.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 供应商过程评价
 * 
 * @author generator
 * 
 */
public class SupplierCourseEvaluateVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private java.lang.String billCode; // 单据编号
    private java.lang.Integer billState; // 单据状态（审批必须字段）
    private java.lang.Long supplierId; // 供方主键
    private java.lang.String supplierName; // 供方名称
    private java.lang.Long supplierCategoryId; // 供方分类
    private java.lang.String supplierCategoryName; // 供方分类名称
    private java.lang.String supplierLinkman; // 供方联系人
    private java.lang.String supplierMobile; // 供方联系电话
    private java.math.BigDecimal supplierRegisteredCapital; // 注册资金
    private java.lang.Long evaluationProjectId; // 评价项目主键
    private java.lang.String evaluationProjectName; // 评价项目名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date evaluationTime; // 评价时间
    private java.math.BigDecimal evaluationScore; // 评价得分
    private java.lang.Integer evaluationGrade; // 评价等级(1-合格，0-不合格)
    private java.lang.String assessor; // 参加考评人员
    private java.lang.Long projectManager; // 项目经理
    private java.lang.String projectManagerName; // 项目经理名称
    private java.lang.Long orgId; // 所属组织
    private java.lang.String orgName; // 所属组织名称
    private java.lang.Integer billType; // 1-分包；2-物资
    private String evaluationGradeName; // 评价等级名称
    private String billStateName; // 单据状态名称
    private String quarter; //季度

    private List<SupplierCourseReviewEvaluateVO> evaluateList = new ArrayList<>(); // 供应商过程评价评审项目

    private List<SupplierCourseMisconductEvaluateVO> misconductRecordList = new ArrayList<>();

    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 供方主键
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public java.lang.Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供方主键
     */
    @ReferDeserialTransfer
    public void setSupplierId(java.lang.Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供方名称
     */
    public java.lang.String getSupplierName() {
        return supplierName;
    }

    /**
     * 供方名称
     */
    public void setSupplierName(java.lang.String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 供方分类
     */
    public java.lang.Long getSupplierCategoryId() {
        return supplierCategoryId;
    }

    /**
     * 供方分类
     */
    public void setSupplierCategoryId(java.lang.Long supplierCategoryId) {
        this.supplierCategoryId = supplierCategoryId;
    }
    /**
     * 供方分类名称
     */
    public java.lang.String getSupplierCategoryName() {
        return supplierCategoryName;
    }

    /**
     * 供方分类名称
     */
    public void setSupplierCategoryName(java.lang.String supplierCategoryName) {
        this.supplierCategoryName = supplierCategoryName;
    }
    /**
     * 供方联系人
     */
    public java.lang.String getSupplierLinkman() {
        return supplierLinkman;
    }

    /**
     * 供方联系人
     */
    public void setSupplierLinkman(java.lang.String supplierLinkman) {
        this.supplierLinkman = supplierLinkman;
    }
    /**
     * 供方联系电话
     */
    public java.lang.String getSupplierMobile() {
        return supplierMobile;
    }

    /**
     * 供方联系电话
     */
    public void setSupplierMobile(java.lang.String supplierMobile) {
        this.supplierMobile = supplierMobile;
    }
    /**
     * 注册资金
     */
    public java.math.BigDecimal getSupplierRegisteredCapital() {
        return supplierRegisteredCapital;
    }

    /**
     * 注册资金
     */
    public void setSupplierRegisteredCapital(java.math.BigDecimal supplierRegisteredCapital) {
        this.supplierRegisteredCapital = supplierRegisteredCapital;
    }
    /**
     * 评价项目主键
     */
    @ReferSerialTransfer(referCode="market-project")
    public java.lang.Long getEvaluationProjectId() {
        return evaluationProjectId;
    }

    /**
     * 评价项目主键
     */
    @ReferDeserialTransfer
    public void setEvaluationProjectId(java.lang.Long evaluationProjectId) {
        this.evaluationProjectId = evaluationProjectId;
    }
    /**
     * 评价项目名称
     */
    public java.lang.String getEvaluationProjectName() {
        return evaluationProjectName;
    }

    /**
     * 评价项目名称
     */
    public void setEvaluationProjectName(java.lang.String evaluationProjectName) {
        this.evaluationProjectName = evaluationProjectName;
    }
    /**
     * 评价时间
     */
    public java.util.Date getEvaluationTime() {
        return evaluationTime;
    }

    /**
     * 评价时间
     */
    public void setEvaluationTime(java.util.Date evaluationTime) {
        this.evaluationTime = evaluationTime;
    }
    /**
     * 评价得分
     */
    public java.math.BigDecimal getEvaluationScore() {
        return evaluationScore;
    }

    /**
     * 评价得分
     */
    public void setEvaluationScore(java.math.BigDecimal evaluationScore) {
        this.evaluationScore = evaluationScore;
    }
    /**
     * 评价等级(1-合格，0-不合格)
     */
    public java.lang.Integer getEvaluationGrade() {
        return evaluationGrade;
    }

    /**
     * 评价等级(1-合格，0-不合格)
     */
    public void setEvaluationGrade(java.lang.Integer evaluationGrade) {
        this.evaluationGrade = evaluationGrade;
    }
    /**
     * 参加考评人员
     */
    public java.lang.String getAssessor() {
        return assessor;
    }

    /**
     * 参加考评人员
     */
    public void setAssessor(java.lang.String assessor) {
        this.assessor = assessor;
    }
    /**
     * 项目经理
     */
    public java.lang.Long getProjectManager() {
        return projectManager;
    }

    /**
     * 项目经理
     */
    public void setProjectManager(java.lang.Long projectManager) {
        this.projectManager = projectManager;
    }
    /**
     * 项目经理名称
     */
    public String getProjectManagerName() {
        return projectManagerName;
    }
    /**
     * 项目经理名称
     */
    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }

    /**
     * 所属组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织
     */
    @ReferDeserialTransfer
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 1-分包；2-物资
     */
    public java.lang.Integer getBillType() {
        return billType;
    }

    /**
     * 1-分包；2-物资
     */
    public void setBillType(java.lang.Integer billType) {
        this.billType = billType;
    }

    public String getEvaluationGradeName() {
        return evaluationGradeName;
    }

    public void setEvaluationGradeName(String evaluationGradeName) {
        this.evaluationGradeName = evaluationGradeName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getQuarter() {
        return quarter;
    }

    public void setQuarter(String quarter) {
        this.quarter = quarter;
    }

    public List<SupplierCourseReviewEvaluateVO> getEvaluateList() {
        return evaluateList;
    }

    public void setEvaluateList(List<SupplierCourseReviewEvaluateVO> evaluateList) {
        this.evaluateList = evaluateList;
    }

    public List<SupplierCourseMisconductEvaluateVO> getMisconductRecordList() {
        return misconductRecordList;
    }

    public void setMisconductRecordList(List<SupplierCourseMisconductEvaluateVO> misconductRecordList) {
        this.misconductRecordList = misconductRecordList;
    }
}
