package com.ejianc.business.supplier.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 供应商年度评价
 * 
 * @author generator
 * 
 */
public class SupplierYearEvaluateVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态（审批必须字段）
    private Long supplierId; // 供方主键
    private String supplierName; // 供方名称
    private String supplierLinkman; // 供方联系人
    private String supplierMobile; // 供方联系电话
    private java.math.BigDecimal supplierRegisteredCapital; // 注册资金
    private Long evaluationOrgId; // 评价单位主键
    private String evaluationOrgName; // 评价单位名称
    @JsonFormat(pattern = "yyyy", timezone = "GMT+8")
    private java.util.Date evaluationYear; // 评价年度
    private java.math.BigDecimal yearEvaluationScore; // 年度评价得分
    private Integer evaluationGrade; // 评价等级(1-合格，0-不合格)
    private String assessor; // 参加考评人员
    private Long supplierCategoryId; // 供方分类主键
    private String supplierCategoryName; // 供方分类名称
    private Integer billType; // 1-分包；2-物资
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date evaluationDate; // 评价时间
    private String evaluationGradeName; // 评价等级名称
    private String billStateName; // 单据状态名称


    private List<SupplierYearReviewEvaluateVO> evaluateList = new ArrayList<>(); // 供应商年度评价评审项目

    private List<SupplierYearCourseEvaluateVO> courseList = new ArrayList<>(); //

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 供方主键
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供方主键
     */
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供方名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供方名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 供方联系人
     */
    public String getSupplierLinkman() {
        return supplierLinkman;
    }

    /**
     * 供方联系人
     */
    public void setSupplierLinkman(String supplierLinkman) {
        this.supplierLinkman = supplierLinkman;
    }
    /**
     * 供方联系电话
     */
    public String getSupplierMobile() {
        return supplierMobile;
    }

    /**
     * 供方联系电话
     */
    public void setSupplierMobile(String supplierMobile) {
        this.supplierMobile = supplierMobile;
    }
    /**
     * 注册资金
     */
    public java.math.BigDecimal getSupplierRegisteredCapital() {
        return supplierRegisteredCapital;
    }

    /**
     * 注册资金
     */
    public void setSupplierRegisteredCapital(java.math.BigDecimal supplierRegisteredCapital) {
        this.supplierRegisteredCapital = supplierRegisteredCapital;
    }
    /**
     * 评价单位主键
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getEvaluationOrgId() {
        return evaluationOrgId;
    }

    /**
     * 评价单位主键
     */
    @ReferDeserialTransfer
    public void setEvaluationOrgId(Long evaluationOrgId) {
        this.evaluationOrgId = evaluationOrgId;
    }
    /**
     * 评价单位名称
     */
    public String getEvaluationOrgName() {
        return evaluationOrgName;
    }

    /**
     * 评价单位名称
     */
    public void setEvaluationOrgName(String evaluationOrgName) {
        this.evaluationOrgName = evaluationOrgName;
    }
    /**
     * 评价年度
     */
    public java.util.Date getEvaluationYear() {
        return evaluationYear;
    }

    /**
     * 评价年度
     */
    public void setEvaluationYear(java.util.Date evaluationYear) {
        this.evaluationYear = evaluationYear;
    }
    /**
     * 年度评价得分
     */
    public java.math.BigDecimal getYearEvaluationScore() {
        return yearEvaluationScore;
    }

    /**
     * 年度评价得分
     */
    public void setYearEvaluationScore(java.math.BigDecimal yearEvaluationScore) {
        this.yearEvaluationScore = yearEvaluationScore;
    }
    /**
     * 评价等级(1-合格，0-不合格)
     */
    public Integer getEvaluationGrade() {
        return evaluationGrade;
    }

    /**
     * 评价等级(1-合格，0-不合格)
     */
    public void setEvaluationGrade(Integer evaluationGrade) {
        this.evaluationGrade = evaluationGrade;
    }
    /**
     * 参加考评人员
     */
    public String getAssessor() {
        return assessor;
    }

    /**
     * 参加考评人员
     */
    public void setAssessor(String assessor) {
        this.assessor = assessor;
    }
    /**
     * 供方分类主键
     */
    //@ReferSerialTransfer(referCode = "support-supplier-category")
    public Long getSupplierCategoryId() {
        return supplierCategoryId;
    }

    /**
     * 供方分类主键
     */
    //@ReferDeserialTransfer
    public void setSupplierCategoryId(Long supplierCategoryId) {
        this.supplierCategoryId = supplierCategoryId;
    }
    /**
     * 供方分类名称
     */
    public String getSupplierCategoryName() {
        return supplierCategoryName;
    }

    /**
     * 供方分类名称
     */
    public void setSupplierCategoryName(String supplierCategoryName) {
        this.supplierCategoryName = supplierCategoryName;
    }
    /**
     * 1-分包；2-物资
     */
    public Integer getBillType() {
        return billType;
    }

    /**
     * 1-分包；2-物资
     */
    public void setBillType(Integer billType) {
        this.billType = billType;
    }

    public List<SupplierYearReviewEvaluateVO> getEvaluateList() {
        return evaluateList;
    }

    public void setEvaluateList(List<SupplierYearReviewEvaluateVO> evaluateList) {
        this.evaluateList = evaluateList;
    }

    public Date getEvaluationDate() {
        return evaluationDate;
    }

    public void setEvaluationDate(Date evaluationDate) {
        this.evaluationDate = evaluationDate;
    }

    public String getEvaluationGradeName() {
        return evaluationGradeName;
    }

    public void setEvaluationGradeName(String evaluationGradeName) {
        this.evaluationGradeName = evaluationGradeName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<SupplierYearCourseEvaluateVO> getCourseList() {
        return courseList;
    }

    public void setCourseList(List<SupplierYearCourseEvaluateVO> courseList) {
        this.courseList = courseList;
    }
}
