package com.ejianc.business.supplier.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 供应商银行账户
 * 
 * @author generator
 * 
 */
public class BankAccountVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long accessId; // 供应商准入id
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String insideOrgId; // 预留
    private String bankCode; // 账户
    private String bankAccount; // 户名
    private Long bankId; // 银行主键
    private String bankName; // 开户银行
    private Long categoryId; // 银行类别主键
    private String categoryName; // 银行类别名称
    private String memo; // 备注
    private Integer defaultFlag; // 是否默认(1:是，0：否)

    private Integer excelIndex; // 在excel中是第几行数据
    private Boolean importFlag; // 列是否可以导入，true=可以导入，false=不可导入
    private String warnType; // 错误信息
    
    /**
     * 供应商准入id
     */
    public Long getAccessId() {
        return accessId;
    }

    /**
     * 供应商准入id
     */
    public void setAccessId(Long accessId) {
        this.accessId = accessId;
    }
    
    /**
     * 所属组织id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    /**
     * 预留
     */
    public String getInsideOrgId() {
        return insideOrgId;
    }

    /**
     * 预留
     */
    public void setInsideOrgId(String insideOrgId) {
        this.insideOrgId = insideOrgId;
    }
    
    /**
     * 账户
     */
    public String getBankCode() {
        return bankCode;
    }

    /**
     * 账户
     */
    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }
    /**
     * 户名
     */
    public String getBankAccount() {
        return bankAccount;
    }

    /**
     * 户名
     */
    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }
    /**
     * 银行主键
     */
    @ReferSerialTransfer(referCode="support-bank")
    public Long getBankId() {
        return bankId;
    }

    /**
     * 银行主键
     */
    @ReferDeserialTransfer
    public void setBankId(Long bankId) {
        this.bankId = bankId;
    }
    /**
     * 开户银行
     */
    public String getBankName() {
        return bankName;
    }

    /**
     * 开户银行
     */
    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    /**
     * 银行类别主键
     */
    public Long getCategoryId() {
        return categoryId;
    }

    /**
     * 银行类别主键
     */
    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    /**
     * 银行类别名称
     */
    public String getCategoryName() {
        return categoryName;
    }

    /**
     * 银行类别名称
     */
    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 是否默认(1:是，0：否)
     */
    public Integer getDefaultFlag() {
        return defaultFlag;
    }

    /**
     * 是否默认(1:是，0：否)
     */
    public void setDefaultFlag(Integer defaultFlag) {
        this.defaultFlag = defaultFlag;
    }

    public Integer getExcelIndex() {
        return excelIndex;
    }

    public void setExcelIndex(Integer excelIndex) {
        this.excelIndex = excelIndex;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }
}
