/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supplier.bean.AccessEntity;
import com.ejianc.business.supplier.service.IAccessService;
import com.ejianc.business.supplier.utils.FeignUtil;
import com.ejianc.business.supplier.vo.AccessVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"access"})
public class AccessController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private FeignUtil feignUtil;
    @Autowired
    private IAccessService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AccessVO> saveOrUpdate(@RequestBody AccessVO saveorUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdate(saveorUpdateVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AccessVO> queryDetail(Long id) {
        AccessEntity entity = (AccessEntity)((Object)this.service.selectById(id));
        AccessVO vo = (AccessVO)BeanMapper.map((Object)((Object)entity), AccessVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AccessVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AccessVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List list = BeanMapper.mapList((Iterable)page.getRecords(), AccessVO.class);
        Map<Long, String> defdocMap = this.feignUtil.getDefdocMap(304562056877981790L);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (AccessVO vo : list) {
                vo.setEnterpriseNatureName(defdocMap.get(vo.getEnterpriseNature()));
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            }
        }
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<AccessVO> list = this.service.excelExport(param, response);
        HashMap<String, List<AccessVO>> beans = new HashMap<String, List<AccessVO>>();
        beans.put("records", list);
        String billType = ((Parameter)param.getParams().get("billType")).getValue().toString();
        if (Integer.parseInt(billType) == 1) {
            ExcelExport.getInstance().export("sub-access-export.xlsx", beans, response);
        } else {
            ExcelExport.getInstance().export("material-access-export.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"bank-account-import.xlsx", (String)"\u94f6\u884c\u8d26\u6237\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/bankImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> bankImport(HttpServletRequest request, HttpServletResponse response) {
        return CommonResponse.success((String)"\u5355\u4f4d\u94f6\u884c\u4fe1\u606f\u5bfc\u5165\u6210\u529f", (Object)this.service.bankImport(request, response));
    }
}

