/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supplier.service.impl;

import com.ejianc.business.supplier.bean.AccessEntity;
import com.ejianc.business.supplier.bean.BankAccountEntity;
import com.ejianc.business.supplier.mapper.AccessMapper;
import com.ejianc.business.supplier.service.IAccessService;
import com.ejianc.business.supplier.service.IBankAccountService;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.supplier.api.ISupplierAccountApi;
import com.ejianc.foundation.supplier.vo.SuplBankAccountVO;
import com.ejianc.foundation.supplier.vo.SuplHistoricalPerformanceVO;
import com.ejianc.foundation.supplier.vo.SuplLinkerVO;
import com.ejianc.foundation.supplier.vo.SuplSupplierVO;
import com.ejianc.foundation.support.api.ISupplierWebApi;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="access")
public class AccessBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IAccessService accessService;
    @Autowired
    private AccessMapper accessMapper;
    @Autowired
    private ISupplierWebApi supplierWebApi;
    @Autowired
    private ISupplierAccountApi supplierAccountApi;
    @Autowired
    private IBankAccountService bankAccountService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        AccessEntity entity = (AccessEntity)((Object)this.accessService.selectById(billId));
        List<String> creditCodeList = this.accessMapper.querySocialCreditCode(tenantId, 1, billId);
        CommonResponse supplierRes = this.supplierWebApi.querySupplierList();
        if (!supplierRes.isSuccess() || !CollectionUtils.isNotEmpty((Collection)((Collection)supplierRes.getData()))) {
            throw new BusinessException("\u6821\u9a8c\u4f9b\u5e94\u5546\u662f\u5426\u5b58\u5728\u5931\u8d25\uff01");
        }
        creditCodeList.addAll(((List)supplierRes.getData()).stream().map(SupplierVO::getSocialCreditCode).collect(Collectors.toList()));
        if (creditCodeList.contains(entity.getSocialCreditCode())) {
            throw new BusinessException("\u63d0\u4ea4\u5931\u8d25\uff0c\u8be5\u4f9b\u5e94\u5546\u5df2\u5b58\u5728\uff01");
        }
        List<BankAccountEntity> bankAccountList = entity.getBankAccountList();
        if (CollectionUtil.isNotEmpty(bankAccountList)) {
            List<String> bankCodeList = this.bankAccountService.queryBankCode(tenantId, 1, entity.getId());
            CommonResponse bankRes = this.supplierWebApi.queryBankAccountList();
            if (!bankRes.isSuccess() || !CollectionUtils.isNotEmpty((Collection)((Collection)bankRes.getData()))) {
                throw new BusinessException("\u6821\u9a8c\u94f6\u884c\u8d26\u53f7\u662f\u5426\u5b58\u5728\u5931\u8d25\uff01");
            }
            bankCodeList.addAll(((List)bankRes.getData()).stream().map(BankAccountVO::getBankCode).collect(Collectors.toList()));
            for (BankAccountEntity bankAccountEntity : bankAccountList) {
                if (!bankCodeList.contains(bankAccountEntity.getBankCode())) continue;
                throw new BusinessException("\u63d0\u4ea4\u5931\u8d25\uff0c\u94f6\u884c\u8d26\u6237" + bankAccountEntity.getBankCode() + "\u5df2\u5b58\u5728\uff01");
            }
        }
        SuplSupplierVO vo = (SuplSupplierVO)BeanMapper.map((Object)((Object)entity), SuplSupplierVO.class);
        List linkerVOList = BeanMapper.mapList(entity.getLinkerList(), SuplLinkerVO.class);
        List historicalPerformanceVOList = BeanMapper.mapList(entity.getHistoricalPerformanceList(), SuplHistoricalPerformanceVO.class);
        List bankAccountVOList = BeanMapper.mapList(entity.getBankAccountList(), SuplBankAccountVO.class);
        if (entity.getBillType() == 1) {
            vo.setSupplierFlag(Integer.valueOf(0));
            vo.setSubFlag(Integer.valueOf(1));
        } else {
            vo.setSupplierFlag(Integer.valueOf(1));
            vo.setSubFlag(Integer.valueOf(0));
        }
        vo.setLinkerList(linkerVOList);
        vo.setHistoricalPerformanceList(historicalPerformanceVOList);
        vo.setBankAccountList(bankAccountVOList);
        this.supplierAccountApi.sysSupplier(vo);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse response = this.supplierAccountApi.getSupplierByAccessId(billId);
        if (response.isSuccess()) {
            List list = (List)response.getData();
            if (CollectionUtil.isEmpty((Collection)list)) {
                return CommonResponse.success();
            }
            throw new BusinessException("\u4f9b\u5e94\u5e93\u672a\u5220\u9664\u8be5\u5355\u636e\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        throw new BusinessException("\u67e5\u8be2\u4f9b\u65b9\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

