/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.supplier.bean.AccessEntity;
import com.ejianc.business.supplier.bean.BankAccountEntity;
import com.ejianc.business.supplier.mapper.AccessMapper;
import com.ejianc.business.supplier.service.IAccessService;
import com.ejianc.business.supplier.service.IBankAccountService;
import com.ejianc.business.supplier.utils.DetailIndexExcelReader;
import com.ejianc.business.supplier.utils.FeignUtil;
import com.ejianc.business.supplier.vo.AccessVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.ISupplierWebApi;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.foundation.support.vo.BankVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="accessService")
public class AccessServiceImpl
extends BaseServiceImpl<AccessMapper, AccessEntity>
implements IAccessService {
    private static final String BILL_CODE = "SUPPLIER_ACCESS";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBankAccountService bankAccountService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private FeignUtil feignUtil;
    @Autowired
    private ISupplierWebApi supplierWebApi;

    @Override
    public AccessVO saveOrUpdate(AccessVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        AccessEntity entity = (AccessEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, AccessEntity.class));
        int flag = 1;
        if (entity.getId() == null || entity.getId() == 0L) {
            flag = 0;
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
            }
        }
        List<String> creditCodeList = ((AccessMapper)this.baseMapper).querySocialCreditCode(tenantId, flag, entity.getId());
        CommonResponse supplierRes = this.supplierWebApi.querySupplierList();
        if (!supplierRes.isSuccess() || !CollectionUtils.isNotEmpty((Collection)((Collection)supplierRes.getData()))) {
            throw new BusinessException("\u6821\u9a8c\u4f9b\u5e94\u5546\u662f\u5426\u5b58\u5728\u5931\u8d25\uff01");
        }
        creditCodeList.addAll(((List)supplierRes.getData()).stream().map(SupplierVO::getSocialCreditCode).collect(Collectors.toList()));
        if (creditCodeList.contains(entity.getSocialCreditCode())) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u4f9b\u5e94\u5546\u5df2\u5b58\u5728\uff01");
        }
        List<BankAccountEntity> bankAccountList = entity.getBankAccountList();
        if (CollectionUtil.isNotEmpty(bankAccountList)) {
            List<String> bankCodeList = this.bankAccountService.queryBankCode(tenantId, flag, entity.getId());
            CommonResponse bankRes = this.supplierWebApi.queryBankAccountList();
            if (!bankRes.isSuccess() || !CollectionUtils.isNotEmpty((Collection)((Collection)bankRes.getData()))) {
                throw new BusinessException("\u6821\u9a8c\u94f6\u884c\u8d26\u53f7\u662f\u5426\u5b58\u5728\u5931\u8d25\uff01");
            }
            bankCodeList.addAll(((List)bankRes.getData()).stream().map(BankAccountVO::getBankCode).collect(Collectors.toList()));
            for (BankAccountEntity bankAccountEntity : bankAccountList) {
                if (!bankCodeList.contains(bankAccountEntity.getBankCode())) continue;
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u94f6\u884c\u8d26\u6237" + bankAccountEntity.getBankCode() + "\u5df2\u5b58\u5728\uff01");
            }
        }
        entity.setApplyTime(new Date());
        this.saveOrUpdate((Object)entity, false);
        AccessVO vo = (AccessVO)BeanMapper.map((Object)((Object)entity), AccessVO.class);
        return vo;
    }

    @Override
    public List<AccessVO> excelExport(QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, AccessVO.class);
        Map<Long, String> defdocMap = this.feignUtil.getDefdocMap(304562056877981790L);
        if (CollectionUtil.isNotEmpty((Collection)voList)) {
            for (AccessVO vo : voList) {
                vo.setEnterpriseNatureName(defdocMap.get(vo.getEnterpriseNature()));
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            }
        }
        return voList;
    }

    @Override
    public JSONObject bankImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            throw new BusinessException("\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List<List<String>> result = DetailIndexExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                throw new BusinessException("\u5206\u7c7b\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            CommonResponse commonResponse = this.supplierWebApi.queryBankList();
            List bankVOList = new ArrayList();
            if (!commonResponse.isSuccess() || !CollectionUtils.isNotEmpty((Collection)((Collection)commonResponse.getData()))) {
                throw new BusinessException("\u67e5\u8be2\u94f6\u884c\u6863\u6848\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\uff01");
            }
            bankVOList = (List)commonResponse.getData();
            Map map = bankVOList.stream().collect(Collectors.toMap(BankVO::getName, Function.identity(), (o, n) -> o));
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<com.ejianc.business.supplier.vo.BankAccountVO> successList = new ArrayList<com.ejianc.business.supplier.vo.BankAccountVO>();
            ArrayList<com.ejianc.business.supplier.vo.BankAccountVO> errorList = new ArrayList<com.ejianc.business.supplier.vo.BankAccountVO>();
            Boolean defaultFlag = false;
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                com.ejianc.business.supplier.vo.BankAccountVO vo = new com.ejianc.business.supplier.vo.BankAccountVO();
                vo.setExcelIndex(Integer.valueOf(i + 2));
                String warnType = "";
                boolean flag = false;
                String bankCode = datas.get(0);
                String bankAccount = datas.get(1);
                String bankName = datas.get(2);
                String categoryName = datas.get(3);
                String memo = datas.get(4);
                Long pk = IdWorker.getId();
                String id = pk.toString();
                vo.setId(pk);
                if (StringUtils.isEmpty((CharSequence)bankCode)) {
                    vo.setBankCode(null);
                    warnType = warnType + "[\u8d26\u6237\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    if (indexMap.containsKey(bankCode)) {
                        throw new BusinessException("\u7b2c" + (i + 2) + "\u884c\u8d26\u53f7\u548c\u7b2c" + ((Integer)indexMap.get(bankCode) + 2) + "\u884c\u91cd\u590d");
                    }
                    indexMap.put(bankCode, i);
                    vo.setBankCode(bankCode);
                }
                if (StringUtils.isEmpty((CharSequence)bankAccount)) {
                    vo.setBankAccount(null);
                    warnType = warnType + "[\u6237\u540d\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setBankAccount(bankAccount);
                }
                if (StringUtils.isEmpty((CharSequence)bankName)) {
                    vo.setBankName(null);
                    warnType = warnType + "[\u5f00\u6237\u94f6\u884c\u4e3a\u7a7a]";
                    flag = true;
                } else if (map.containsKey(bankName)) {
                    BankVO bankVO = (BankVO)map.get(bankName);
                    vo.setBankId(bankVO.getId());
                    vo.setBankName(bankName);
                    vo.setCategoryId(bankVO.getBankCategoryId());
                    vo.setCategoryName(bankVO.getBankCategoryName());
                } else {
                    vo.setBankName(null);
                    warnType = warnType + "[\u94f6\u884c\u6863\u6848\u4e2d\u4e0d\u5b58\u5728\u8be5\u5f00\u6237\u94f6\u884c\u201c&&\u201d]";
                }
                vo.setMemo(memo);
                if (StringUtils.isEmpty((CharSequence)categoryName)) {
                    vo.setCategoryName(null);
                    warnType = warnType + "[\u94f6\u884c\u7c7b\u522b\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setCategoryName(categoryName);
                }
                if (StringUtils.isEmpty((CharSequence)datas.get(5))) {
                    vo.setDefaultFlag(null);
                    warnType = warnType + "[\u9ed8\u8ba4\u4e3a\u7a7a]";
                    flag = true;
                } else if ("\u662f".equals(datas.get(5))) {
                    vo.setDefaultFlag(Integer.valueOf(1));
                    if (defaultFlag.booleanValue()) {
                        vo.setDefaultFlag(null);
                        warnType = warnType + "[\u53ea\u80fd\u6709\u4e00\u4e2a\u9ed8\u8ba4]";
                        flag = true;
                    }
                    defaultFlag = true;
                } else {
                    vo.setDefaultFlag(Integer.valueOf(0));
                }
                vo.setImportFlag(Boolean.valueOf(!flag));
                vo.setRowState("add");
                if (flag) {
                    vo.setWarnType(warnType);
                    errorList.add(vo);
                    continue;
                }
                successList.add(vo);
            }
            resp.put("successList", successList);
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)successList.size());
            resp.put("errorNum", (Object)errorList.size());
            return resp;
        }
        throw new BusinessException("Excel\u4e3a\u7a7a");
    }
}

