package com.ejianc.business.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supplier.bean.SupplierCourseEvaluateEntity;
import com.ejianc.business.supplier.bean.SupplierReviewProjectEntity;
import com.ejianc.business.supplier.bean.SupplierYearEvaluateEntity;
import com.ejianc.business.supplier.service.ISupplierCourseEvaluateService;
import com.ejianc.business.supplier.service.ISupplierReviewProjectService;
import com.ejianc.business.supplier.service.ISupplierYearCourseEvaluateService;
import com.ejianc.business.supplier.service.ISupplierYearEvaluateService;
import com.ejianc.business.supplier.service.impl.SupplierYearEvaluateBpmServiceImpl;
import com.ejianc.business.supplier.vo.SupplierCourseEvaluateVO;
import com.ejianc.business.supplier.vo.SupplierReviewProjectVO;
import com.ejianc.business.supplier.vo.SupplierYearEvaluateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 供应商年度评价
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("supplierYearEvaluate")
public class SupplierYearEvaluateController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SUPPLIER_YEAR_EVALUATE";//此处需要根据实际修改
    
    @Autowired
    private ISupplierYearEvaluateService service;
    @Autowired
    private ISupplierReviewProjectService reviewProjectService;
    @Autowired
    private ISupplierCourseEvaluateService courseEvaluateService;
    @Autowired
    private ISupplierYearCourseEvaluateService yearCourseEvaluateService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SupplierYearEvaluateVO> saveOrUpdate(@RequestBody SupplierYearEvaluateVO saveorUpdateVO) {
    	SupplierYearEvaluateEntity entity = BeanMapper.map(saveorUpdateVO, SupplierYearEvaluateEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else{
            yearCourseEvaluateService.updateDrByYearEvaluateId(entity.getId());
        }
    	service.saveOrUpdate(entity, false);
    	SupplierYearEvaluateVO vo = BeanMapper.map(entity, SupplierYearEvaluateVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplierYearEvaluateVO> queryDetail(Long id) {
    	SupplierYearEvaluateEntity entity = service.selectById(id);
    	SupplierYearEvaluateVO vo = BeanMapper.map(entity, SupplierYearEvaluateVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SupplierYearEvaluateVO> vos) {
        service.removeByIds(vos.stream().map(SupplierYearEvaluateVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SupplierYearEvaluateVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("evaluationOrgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<SupplierYearEvaluateEntity> page = service.queryPage(param,false);
        IPage<SupplierYearEvaluateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<SupplierYearEvaluateVO> supplierYearEvaluateVOS = BeanMapper.mapList(page.getRecords(), SupplierYearEvaluateVO.class);
        supplierYearEvaluateVOS.forEach(e -> {
            if (e.getEvaluationGrade()==1){
                e.setEvaluationGradeName("合格");
            }else{
                e.setEvaluationGradeName("不合格");
            }
        });
        pageData.setRecords(supplierYearEvaluateVOS);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("evaluationOrgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        List<SupplierYearEvaluateEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<SupplierYearEvaluateVO> supplierYearEvaluateVOS = BeanMapper.mapList(list, SupplierYearEvaluateVO.class);
        supplierYearEvaluateVOS.forEach(e -> {
            if (e.getEvaluationGrade()==1){
                e.setEvaluationGradeName("合格");
            }else{
                e.setEvaluationGradeName("不合格");
            }
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
            e.setYearEvaluationScore(e.getYearEvaluationScore().setScale(1, BigDecimal.ROUND_HALF_UP));
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            e.setFormatEvaluationDate(format.format(e.getEvaluationDate()));
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", supplierYearEvaluateVOS);
        ExcelExport.getInstance().export("yearEvaluateExport.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSupplierYearEvaluateData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SupplierYearEvaluateVO>> refSupplierYearEvaluateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SupplierYearEvaluateEntity> page = service.queryPage(param,false);
        IPage<SupplierYearEvaluateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplierYearEvaluateVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    @RequestMapping(value = "/getSupplierReviewProjectList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SupplierReviewProjectVO>> getSupplierReviewProjectList(@RequestParam("billType") Integer billType,@RequestParam("yearType")Integer yearType){
        List<SupplierReviewProjectEntity> supplierReviewProjectList = reviewProjectService.getSupplierReviewProjectList(billType, yearType);
        List<SupplierReviewProjectVO> supplierReviewProjectVOS = BeanMapper.mapList(supplierReviewProjectList, SupplierReviewProjectVO.class);
        return CommonResponse.success(supplierReviewProjectVOS);
    }

    /*
    获取供应商过程评价记录
     */
    @RequestMapping(value = "/getSupplierCourseEvaluateList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SupplierCourseEvaluateVO>> getSupplierCourseEvaluateList(@RequestParam("billType") Integer billType,@RequestParam("supplierId") Long supplierId){
        LambdaQueryWrapper<SupplierCourseEvaluateEntity> queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SupplierCourseEvaluateEntity::getTenantId, InvocationInfoProxy.getTenantid());
        queryWrapper.eq(SupplierCourseEvaluateEntity::getBillType, billType);
        queryWrapper.eq(SupplierCourseEvaluateEntity::getSupplierId, supplierId);
        queryWrapper.in(SupplierCourseEvaluateEntity::getBillState, 1,3);
        queryWrapper.le(SupplierCourseEvaluateEntity::getEvaluationTime, new Date());
        queryWrapper.apply("date_format(evaluation_time, '%Y') = {0}", LocalDateTime.now().getYear());
        List<SupplierCourseEvaluateEntity> list = courseEvaluateService.list(queryWrapper);
        List<SupplierCourseEvaluateVO> SupplierCourseEvaluateVO = BeanMapper.mapList(list, SupplierCourseEvaluateVO.class);
        return CommonResponse.success(SupplierCourseEvaluateVO);
    }


}
