package com.ejianc.business.supplier.service.impl;

import com.ejianc.business.supplier.bean.AccessEntity;
import com.ejianc.business.supplier.bean.BankAccountEntity;
import com.ejianc.business.supplier.mapper.AccessMapper;
import com.ejianc.business.supplier.service.IAccessService;
import com.ejianc.business.supplier.service.IBankAccountService;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.supplier.api.ISupplierAccountApi;
import com.ejianc.foundation.supplier.vo.SuplBankAccountVO;
import com.ejianc.foundation.supplier.vo.SuplHistoricalPerformanceVO;
import com.ejianc.foundation.supplier.vo.SuplLinkerVO;
import com.ejianc.foundation.supplier.vo.SuplSupplierVO;
import com.ejianc.foundation.support.api.ISupplierWebApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service("access") 
public class AccessBpmServiceImpl implements ICommonBusinessService {
	
	@Autowired
	private IAccessService accessService;
	
	@Autowired
	private AccessMapper accessMapper;
	
	@Autowired
	private ISupplierWebApi supplierWebApi;

	@Autowired
	private ISupplierAccountApi supplierAccountApi;
	
	@Autowired
	private IBankAccountService bankAccountService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		Long tenantId = InvocationInfoProxy.getTenantid();
		AccessEntity entity = accessService.selectById(billId);
		
		// 校验 供应商统一社会信用代码 是否重复 需要查询 分包、物资准入和集团供应商库
		List<String> creditCodeList = accessMapper.querySocialCreditCode(tenantId, 1, billId);
		// 查询集团供应商库
		CommonResponse<List<SupplierVO>> supplierRes = supplierWebApi.querySupplierList();
		if(supplierRes.isSuccess() && CollectionUtils.isNotEmpty(supplierRes.getData())){
			creditCodeList.addAll(supplierRes.getData().stream().map(SupplierVO::getSocialCreditCode).collect(Collectors.toList()));
		}else {
			throw new BusinessException("校验供应商是否存在失败！");
		}

		if (creditCodeList.contains(entity.getSocialCreditCode())) {
			throw new BusinessException("提交失败，该供应商已存在！");
		}

		List<BankAccountEntity> bankAccountList = entity.getBankAccountList();
		if (CollectionUtil.isNotEmpty(bankAccountList)) {
			// 校验银行账号不能重复
			List<String> bankCodeList = bankAccountService.queryBankCode(tenantId, 1, entity.getId());
			// 查询银行账户
			CommonResponse<List<com.ejianc.foundation.support.vo.BankAccountVO>> bankRes = supplierWebApi.queryBankAccountList();
			if(bankRes.isSuccess() && CollectionUtils.isNotEmpty(bankRes.getData())){
				bankCodeList.addAll(bankRes.getData().stream().map(com.ejianc.foundation.support.vo.BankAccountVO::getBankCode).collect(Collectors.toList()));
			}else {
				throw new BusinessException("校验银行账号是否存在失败！");
			}

			for (BankAccountEntity bankAccountEntity : bankAccountList) {
				if (bankCodeList.contains(bankAccountEntity.getBankCode())) {
					throw new BusinessException("提交失败，银行账户" + bankAccountEntity.getBankCode() + "已存在！");
				}
			}
		}

		SuplSupplierVO vo = BeanMapper.map(entity, SuplSupplierVO.class);
		List<SuplLinkerVO> linkerVOList = BeanMapper.mapList(entity.getLinkerList(), SuplLinkerVO.class);
		List<SuplHistoricalPerformanceVO> historicalPerformanceVOList = BeanMapper.mapList(entity.getHistoricalPerformanceList(), SuplHistoricalPerformanceVO.class);
		List<SuplBankAccountVO> bankAccountVOList = BeanMapper.mapList(entity.getBankAccountList(), SuplBankAccountVO.class);
		if (entity.getBillType() == 1) {
			vo.setSupplierFlag(0);
			vo.setSubFlag(1);
		}else {
			vo.setSupplierFlag(1);
			vo.setSubFlag(0);
		}
		vo.setLinkerList(linkerVOList);
		vo.setHistoricalPerformanceList(historicalPerformanceVOList);
		vo.setBankAccountList(bankAccountVOList);
		// 推送供应商库
		supplierAccountApi.sysSupplier(vo);
		
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		CommonResponse<List<SupplierVO>> response = supplierAccountApi.getSupplierByAccessId(billId);
		if (response.isSuccess()) {
			List<SupplierVO> list = response.getData();
			if (CollectionUtil.isEmpty(list)) {
				return CommonResponse.success();
			}else {
				throw new BusinessException("供应库未删除该单据，不能撤回！");
			}
		}else {
			throw new BusinessException("查询供方失败，请重试！");
		}
		
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
