package com.ejianc.business.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.supplier.bean.AccessEntity;
import com.ejianc.business.supplier.bean.BankAccountEntity;
import com.ejianc.business.supplier.mapper.AccessMapper;
import com.ejianc.business.supplier.service.IAccessService;
import com.ejianc.business.supplier.service.IBankAccountService;
import com.ejianc.business.supplier.utils.DetailIndexExcelReader;
import com.ejianc.business.supplier.utils.FeignUtil;
import com.ejianc.business.supplier.vo.AccessVO;
import com.ejianc.business.supplier.vo.BankAccountVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.ISupplierWebApi;
import com.ejianc.foundation.support.vo.BankVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 供应商准入
 * 
 * @author generator
 * 
 */
@Service("accessService")
public class AccessServiceImpl extends BaseServiceImpl<AccessMapper, AccessEntity> implements IAccessService{

    private static final String BILL_CODE = "SUPPLIER_ACCESS";//此处需要根据实际修改
    
    @Autowired
    private IBillCodeApi billCodeApi;
    
    @Autowired
    private IBankAccountService bankAccountService;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private FeignUtil feignUtil;
    
    @Autowired
    private ISupplierWebApi supplierWebApi;
    
    @Override
    public AccessVO saveOrUpdate(AccessVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        
        AccessEntity entity = BeanMapper.map(saveorUpdateVO, AccessEntity.class);
        int flag = 1;
        
        if(entity.getId() == null || entity.getId() == 0){
            flag = 0;
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试！");
            }
        }
        
        // 校验 供应商统一社会信用代码 是否重复 需要查询 分包、物资准入和集团供应商库
        List<String> creditCodeList = baseMapper.querySocialCreditCode(tenantId, flag, entity.getId());
        // 查询集团供应商库
        CommonResponse<List<SupplierVO>> supplierRes = supplierWebApi.querySupplierList();
        if(supplierRes.isSuccess() && CollectionUtils.isNotEmpty(supplierRes.getData())){
            creditCodeList.addAll(supplierRes.getData().stream().map(SupplierVO::getSocialCreditCode).collect(Collectors.toList()));
        }else {
            throw new BusinessException("校验供应商是否存在失败！");   
        }
        
        if (creditCodeList.contains(entity.getSocialCreditCode())) {
            throw new BusinessException("保存失败，该供应商已存在！");
        }

        List<BankAccountEntity> bankAccountList = entity.getBankAccountList();
        if (CollectionUtil.isNotEmpty(bankAccountList)) {
            // 校验银行账号不能重复
            List<String> bankCodeList = bankAccountService.queryBankCode(tenantId, flag, entity.getId());
            // 查询银行账户
            CommonResponse<List<com.ejianc.foundation.support.vo.BankAccountVO>> bankRes = supplierWebApi.queryBankAccountList();
            if(bankRes.isSuccess() && CollectionUtils.isNotEmpty(bankRes.getData())){
                bankCodeList.addAll(bankRes.getData().stream().map(com.ejianc.foundation.support.vo.BankAccountVO::getBankCode).collect(Collectors.toList()));
            }else {
                throw new BusinessException("校验银行账号是否存在失败！");
            }

            for (BankAccountEntity bankAccountEntity : bankAccountList) {
                if (bankCodeList.contains(bankAccountEntity.getBankCode())) {
                    throw new BusinessException("保存失败，银行账户" + bankAccountEntity.getBankCode() + "已存在！");
                }
            }
        }
        
        entity.setApplyTime(new Date());
        this.saveOrUpdate(entity, false);
        AccessVO vo = BeanMapper.map(entity, AccessVO.class);
        
        return vo;
    }

    @Override
    public List<AccessVO> excelExport(QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.setPageIndex(1);
        param.setPageSize(-1);

        List<AccessEntity> list = this.queryList(param);
        List<AccessVO> voList = BeanMapper.mapList(list, AccessVO.class);
        // 查询企业性质自定义档案
        Map<Long, String> defdocMap = feignUtil.getDefdocMap(304562056877981790L);
        if (CollectionUtil.isNotEmpty(voList)) {
            for (AccessVO vo : voList) {
                vo.setEnterpriseNatureName(defdocMap.get(vo.getEnterpriseNature()));
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            }
        }

        return voList;
    }
    
    @Override
    public JSONObject bankImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            throw new BusinessException("文件格式不合法");
        } else {
            List<List<String>> result = DetailIndexExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                if(result.size() > 10000) {
                    throw new BusinessException("分类数据超过10000条，请分批上传！");
                }
                
                // 查询银行档案
                CommonResponse<List<BankVO>> commonResponse = supplierWebApi.queryBankList();
                List<BankVO> bankVOList = new ArrayList<>();
                if(commonResponse.isSuccess() && CollectionUtils.isNotEmpty(commonResponse.getData())){
                    bankVOList = commonResponse.getData();
                }else {
                    throw new BusinessException("查询银行档案失败，请重新上传！");
                }
                Map<String, BankVO> map = bankVOList.stream().collect(Collectors.toMap(BankVO::getName, Function.identity(), (o ,n) -> o));

                Map<String, Integer> indexMap = new HashMap<>();
                List<BankAccountVO> successList = new ArrayList<>();
                List<BankAccountVO> errorList = new ArrayList<>();
                Boolean defaultFlag = false;
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    BankAccountVO vo = new BankAccountVO();
                    vo.setExcelIndex(i + 2);
                    String warnType = "";
                    boolean flag = false;
                    String bankCode = datas.get(0); // 账户
                    String bankAccount = datas.get(1); // 户名
                    String bankName = datas.get(2); // 开户银行
                    String categoryName = datas.get(3); // 银行类别名称
                    String memo = datas.get(4); // 银行类别名称
//                    String defaultFlag = datas.get(5); // 默认

                    Long pk = IdWorker.getId();
                    String id = pk.toString();
                    vo.setId(pk);
                    
                    if (StringUtils.isEmpty(bankCode)) {
                        vo.setBankCode(null);
                        warnType = warnType + "[账户为空]";
                        flag = true;
                    } else {
                        if (indexMap.containsKey(bankCode)) {//账号重复
                            throw new BusinessException("第"+(i+2)+"行账号和第" + (indexMap.get(bankCode)+2) + "行重复");
                        }else{
                            indexMap.put(bankCode, i);
                            vo.setBankCode(bankCode);
                        }
                    }

                    if (StringUtils.isEmpty(bankAccount)) {
                        vo.setBankAccount(null);
                        warnType = warnType + "[户名为空]";
                        flag = true;
                    } else {
                        vo.setBankAccount(bankAccount);
                    }

                    if (StringUtils.isEmpty(bankName)) {
                        vo.setBankName(null);
                        warnType = warnType + "[开户银行为空]";
                        flag = true;
                    } else {
                        if (map.containsKey(bankName)) {
                            BankVO bankVO = map.get(bankName);
                            vo.setBankId(bankVO.getId());
                            vo.setBankName(bankName);
                            vo.setCategoryId(bankVO.getBankCategoryId());
                            vo.setCategoryName(bankVO.getBankCategoryName());
                        }else {
                            vo.setBankName(null);
                            warnType = warnType + "[银行档案中不存在该开户银行“&&”]";
                        }
                    }

                    vo.setMemo(memo);
                    
                    if (StringUtils.isEmpty(categoryName)) {//银行类别为空
                        vo.setCategoryName(null);
                        warnType =  warnType + "[银行类别为空]";
                        flag = true;
                    } else {
                        vo.setCategoryName(categoryName);
                    }
                    
                    if (StringUtils.isEmpty(datas.get(5))) {// 默认为空
                        vo.setDefaultFlag(null);
                        warnType = warnType + "[默认为空]";
                        flag = true;
                    } else {
                        if ("是".equals(datas.get(5))) {
                            vo.setDefaultFlag(1);
                            // 只能有一个为默认
                            if(defaultFlag){
                                vo.setDefaultFlag(null);
                                warnType = warnType + "[只能有一个默认]";
                                flag = true;
                            }
                            defaultFlag = true;
                        } else {
                            vo.setDefaultFlag(0);
                        }
                    }
                    
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    vo.setRowState("add");

                    if (flag) {
                        vo.setWarnType(warnType);
                        errorList.add(vo);
                    }else {
                        successList.add(vo);
                    }
                }
                
                resp.put("successList", successList);
                resp.put("errorList", errorList);
                resp.put("successNum", successList.size());
                resp.put("errorNum", errorList.size());
                return resp;
            }
            throw new BusinessException("Excel为空");
        }
    }

    
}
