package com.ejianc.business.supplier.utils;

import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
public class FeignUtil {
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IDefdocApi defdocApi;

    public Map<Long, String> getDefdocMap(Long id) {
        CommonResponse<List<DefdocDetailVO>> resp = defdocApi.getDefDocByDefId(id);
        if(resp.isSuccess() && CollectionUtils.isNotEmpty(resp.getData())){
            List<DefdocDetailVO> list = resp.getData();
            return list.stream().collect(Collectors.toMap(DefdocDetailVO::getId, DefdocDetailVO::getName));
        }
        return new HashMap<>();
    }

}
