/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supplier.bean.SupplierCourseEvaluateEntity;
import com.ejianc.business.supplier.bean.SupplierReviewProjectEntity;
import com.ejianc.business.supplier.bean.SupplierYearEvaluateEntity;
import com.ejianc.business.supplier.service.ISupplierCourseEvaluateService;
import com.ejianc.business.supplier.service.ISupplierReviewProjectService;
import com.ejianc.business.supplier.service.ISupplierYearCourseEvaluateService;
import com.ejianc.business.supplier.service.ISupplierYearEvaluateService;
import com.ejianc.business.supplier.vo.SupplierCourseEvaluateVO;
import com.ejianc.business.supplier.vo.SupplierReviewProjectVO;
import com.ejianc.business.supplier.vo.SupplierYearEvaluateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.supplier.api.ISupplierCategoryApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"supplierYearEvaluate"})
public class SupplierYearEvaluateController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "SUPPLIER_YEAR_EVALUATE";
    @Autowired
    private ISupplierYearEvaluateService service;
    @Autowired
    private ISupplierReviewProjectService reviewProjectService;
    @Autowired
    private ISupplierCourseEvaluateService courseEvaluateService;
    @Autowired
    private ISupplierYearCourseEvaluateService yearCourseEvaluateService;
    @Autowired
    private ISupplierCategoryApi supplierCategoryApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SupplierYearEvaluateVO> saveOrUpdate(@RequestBody SupplierYearEvaluateVO saveorUpdateVO) {
        SupplierYearEvaluateEntity entity = (SupplierYearEvaluateEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SupplierYearEvaluateEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        SupplierYearEvaluateVO vo = (SupplierYearEvaluateVO)BeanMapper.map((Object)((Object)entity), SupplierYearEvaluateVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierYearEvaluateVO> queryDetail(Long id) {
        SupplierYearEvaluateEntity entity = (SupplierYearEvaluateEntity)((Object)this.service.selectById(id));
        SupplierYearEvaluateVO vo = (SupplierYearEvaluateVO)BeanMapper.map((Object)((Object)entity), SupplierYearEvaluateVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SupplierYearEvaluateVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SupplierYearEvaluateVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("evaluationOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Parameter supplierCategoryId = (Parameter)param.getParams().get("supplierCategoryId");
        if (supplierCategoryId != null) {
            Long categoryId = Long.valueOf((String)supplierCategoryId.getValue());
            CommonResponse childrenByParentId = this.supplierCategoryApi.findChildrenByParentId(categoryId);
            if (childrenByParentId.isSuccess()) {
                List supplierCategoryIds = (List)childrenByParentId.getData();
                param.getParams().put("supplierCategoryId", new Parameter("in", (Object)supplierCategoryIds));
            } else {
                return CommonResponse.error((String)"\u83b7\u53d6\u4f9b\u5e94\u5546\u5206\u7c7b\u5931\u8d25");
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List supplierYearEvaluateVOS = BeanMapper.mapList((Iterable)page.getRecords(), SupplierYearEvaluateVO.class);
        supplierYearEvaluateVOS.forEach(e -> {
            if (e.getEvaluationGrade() == 1) {
                e.setEvaluationGradeName("\u5408\u683c");
            } else {
                e.setEvaluationGradeName("\u4e0d\u5408\u683c");
            }
        });
        pageData.setRecords(supplierYearEvaluateVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("evaluationOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Parameter supplierCategoryId = (Parameter)param.getParams().get("supplierCategoryId");
        if (supplierCategoryId != null) {
            Long categoryId = Long.valueOf((String)supplierCategoryId.getValue());
            CommonResponse childrenByParentId = this.supplierCategoryApi.findChildrenByParentId(categoryId);
            if (childrenByParentId.isSuccess()) {
                List supplierCategoryIds = (List)childrenByParentId.getData();
                param.getParams().put("supplierCategoryId", new Parameter("in", (Object)supplierCategoryIds));
            } else {
                throw new BusinessException("\u83b7\u53d6\u4f9b\u5e94\u5546\u5206\u7c7b\u5931\u8d25");
            }
        }
        List list = this.service.queryList(param);
        List supplierYearEvaluateVOS = BeanMapper.mapList((Iterable)list, SupplierYearEvaluateVO.class);
        supplierYearEvaluateVOS.forEach(e -> {
            if (e.getEvaluationGrade() == 1) {
                e.setEvaluationGradeName("\u5408\u683c");
            } else {
                e.setEvaluationGradeName("\u4e0d\u5408\u683c");
            }
            e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
            e.setYearEvaluationScore(e.getYearEvaluationScore().setScale(1, 4));
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            e.setFormatEvaluationDate(format.format(e.getEvaluationDate()));
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", supplierYearEvaluateVOS);
        ExcelExport.getInstance().export("yearEvaluateExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSupplierYearEvaluateData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SupplierYearEvaluateVO>> refSupplierYearEvaluateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierYearEvaluateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getSupplierReviewProjectList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SupplierReviewProjectVO>> getSupplierReviewProjectList(@RequestParam(value="billType") Integer billType, @RequestParam(value="yearType") Integer yearType) {
        List<SupplierReviewProjectEntity> supplierReviewProjectList = this.reviewProjectService.getSupplierReviewProjectList(billType, yearType);
        List supplierReviewProjectVOS = BeanMapper.mapList(supplierReviewProjectList, SupplierReviewProjectVO.class);
        return CommonResponse.success((Object)supplierReviewProjectVOS);
    }

    @RequestMapping(value={"/getSupplierCourseEvaluateList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SupplierCourseEvaluateVO>> getSupplierCourseEvaluateList(@RequestParam(value="billType") Integer billType, @RequestParam(value="supplierId") Long supplierId, @RequestParam(value="evaluationYear") String evaluationYear) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq(SupplierCourseEvaluateEntity::getBillType, (Object)billType);
        queryWrapper.eq(SupplierCourseEvaluateEntity::getSupplierId, (Object)supplierId);
        queryWrapper.in(SupplierCourseEvaluateEntity::getBillState, new Object[]{1, 3});
        queryWrapper.le(SupplierCourseEvaluateEntity::getEvaluationTime, (Object)new Date());
        queryWrapper.apply("date_format(evaluation_time, '%Y') = {0}", new Object[]{evaluationYear});
        List list = this.courseEvaluateService.list((Wrapper)queryWrapper);
        List SupplierCourseEvaluateVO2 = BeanMapper.mapList((Iterable)list, SupplierCourseEvaluateVO.class);
        return CommonResponse.success((Object)SupplierCourseEvaluateVO2);
    }
}

