package com.ejianc.business.suppliercn15.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 准入---工程类供应商信息
 * 
 * @author generator
 * 
 */
public class CanInCertVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    private String certName; // 资质证书名称
    private Long certTypeId; // 资质类别
    private String certTypeName; // 资质类别名称
    private String certLevel; // 资质等级：特级/一级/二级/三级/不分等级
    private String certNum; // 证书编号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date passDate; // 有效期，格式均为YYYY-MM-DD
    private String memo; // 其他说明
    private Long pid; // 主表id

    public String getCertName() {
        return certName;
    }

    public void setCertName(String certName) {
        this.certName = certName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getCertTypeId() {
        return certTypeId;
    }
    @ReferDeserialTransfer
    public void setCertTypeId(Long certTypeId) {
        this.certTypeId = certTypeId;
    }

    public String getCertTypeName() {
        return certTypeName;
    }

    public void setCertTypeName(String certTypeName) {
        this.certTypeName = certTypeName;
    }

    public String getCertLevel() {
        return certLevel;
    }

    public void setCertLevel(String certLevel) {
        this.certLevel = certLevel;
    }

    public String getCertNum() {
        return certNum;
    }

    public void setCertNum(String certNum) {
        this.certNum = certNum;
    }

    public Date getPassDate() {
        return passDate;
    }

    public void setPassDate(Date passDate) {
        this.passDate = passDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    
}
