package com.ejianc.foundation.support.api;

import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.hystrix.SupplierHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 供应商API
 *
 * @author CJ
 * @Description:
 * @date 2020/6/30 14:58
 */
@FeignClient(name= "ejc-support-web", url="${common.env.feign-client-url}", path="ejc-support-web", fallback = SupplierHystrix.class)
public interface ISupplierApi {

    /**
     * 根据供应商Id查询供应商信息
     *
     * @param id 供应商Id
     * @return
     */
    @GetMapping("/api/supplierApi/queryById")
    CommonResponse<SupplierVO> queryById(@RequestParam(value = "id") Long id);

    /**
     * 根据ids查询项目详情
     *
     * @param ids
     * @return
     */
    @GetMapping(value = "/api/supplierApi/querySupplierByIds")
    CommonResponse<List<SupplierVO>> querySupplierByIds(@RequestParam(value = "ids") List<Long> ids);

    /**
     * 根据供应商来源Id查询供应商信息
     *
     * @param sourceId 供应商Id
     * @return
     */
    @GetMapping("/api/supplierApi/queryBySourceId")
    CommonResponse<SupplierVO> queryBySourceId(@RequestParam(value = "sourceId") String sourceId);

    /**
     * 新增或者修改
     *
     * @param supplierVo
     * @return
     */
    @PostMapping("/api/supplierApi/saveOrUpdate")
    CommonResponse<SupplierVO> saveOrUpdate(@RequestBody SupplierVO supplierVo);
    @PostMapping("/api/supplierApi/saveOrUpdateBatch")
    CommonResponse<String> saveOrUpdateBatch(@RequestBody List<SupplierVO> vos);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @PostMapping("/api/supplierApi/delete")
    CommonResponse<String> delete(@RequestBody List<Long> ids);

    @GetMapping("/api/supplierApi/getSupplierBySupplierTenantId")
    CommonResponse<SupplierVO> getSupplierBySupplierTenantId(@RequestParam Long supplierTenantId);

    @GetMapping("/api/supplierApi/queryByCode")
    CommonResponse<SupplierVO> queryByCode(@RequestParam(value = "code") String code);

}
