package com.ejianc.foundation.share.hystrix;

import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.PunishVO;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;


/**
 * 大企业供应商rpc服务
 */
@Component
public class ProSupplierHystrix implements IProSupplierApi {


	@Override
	public CommonResponse<SupplierDTO> selectById(Long id) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<List<SupplierDTO>> selectByUpDate(String upDate) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<List<SupplierDTO>> querySupplierByNames(List<String> names) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<List<SupplierDTO>> queryPostSupplierByIds(Map<String,List<Long>> map) {
		return CommonResponse.error("网络问题， 查询失败。");
	}
	@Override
	public CommonResponse<String> pushSupplierToShare( byte[] supplyByte) {
		return CommonResponse.error("网络问题，请稍后重试！");
	}
	@Override
	public CommonResponse<String> pushSupplierToShareZzyj( byte[] supplyByte) {
		return CommonResponse.error("网络问题，请稍后重试！");
	}

	@Override
	public CommonResponse<String> judgeTaxpayerNumIsRepeat(String taxpayerNum, String personal , String supplyType) {
		return CommonResponse.error("网络问题，请稍后重试！");
	}

	@Override
	public CommonResponse<String> punishSupplier(PunishVO punishVO) {
		return CommonResponse.error("网络问题，请稍后重试！");
	}

	/**
	 * 移除供应商异常标签
	 *
	 * @param supplierId
	 * @param gradeId
	 * @param gradeName
	 */
	@Override
	public CommonResponse<String> returnSupplierToNormal(Long supplierId, Long gradeId, String gradeName) {
		return CommonResponse.error("网络问题，请稍后重试！");
	}

	/**
	 * 移除 分包负责人 异常标签
	 *
	 * @param supplierId
	 * @param gradeId
	 * @param gradeName
	 */
	@Override
	public CommonResponse<String> returnSubleaderToNormal(Long supplierId, Long gradeId, String gradeName) {
		return CommonResponse.error("网络问题，请稍后重试！");
	}

	@Override
	public CommonResponse<String> upgradeSupplier(Long supplierId, Long gradeId, String gradeName) {
		return CommonResponse.error("网络问题，请稍后重试！");
	}

	@Override
	public CommonResponse<String> getEjcCloudSystemCode() {
		return CommonResponse.error("网络问题，请稍后重试！");
	}

	/**
	 * 根据供应商id，查询供应商信息
	 *
	 * @param supplierId
	 */
	@Override
	public CommonResponse<SupplierVO> getSupplierInfo(Long supplierId) {
		return CommonResponse.error("网络问题，请稍后重试！");
	}

	/**
	 * 根据供应商id，查询供应商是否真正协同成功
	 *
	 * @param supplierId
	 */
	@Override
	public CommonResponse<Boolean> whetherSupplierCoo(Long supplierId) {
		return CommonResponse.error("网络问题，请稍后重试！");
	}

	/**
	 * 根据供应商id，更新供应商最近合作时间
	 *
	 * @param supplierId
	 */
	@Override
	public CommonResponse<String> updateLastCoDate(Long supplierId) {
		return CommonResponse.error("网络问题，请稍后重试！");
	}

	/**
	 * 根据供应商税号，获取供应商信息
	 *
	 */
	@Override
	public CommonResponse<SupplierDTO> selectByTaxpayerNum(String taxpayerNum) {
		return CommonResponse.error("网络问题，请稍后重试！");
	}

	@Override
	public CommonResponse<List<SupplierDTO>> selectByUnitCodeOrTaxPayerIdentifier(List<String> unitCodeOrTaxPayerIdentifier)  {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	/**
	 * 根据供应商税号 或者 名称 校验供应商是否一致
	 * 不一致，返回失败，并提示信息不一致的信息
	 * 一致，返回成功
	 *
	 * @param taxpayerNum
	 * @param name
	 */
	@Override
	public CommonResponse<Boolean> checkTaxpayerNumOrNameIsSame(String taxpayerNum, String name) {
		return CommonResponse.error("网络问题，请稍后重试！");
	}

	/**
	 * 根据供应商id和分包负责人身份证号 校验分包负责人是否在该供应商下存在
	 * 不存在，返回false，并提示信息不一致的信息
	 * 存在，返回true
	 * @param supplierId 供应商id
	 * @param idCardNum  分包负责人身份证号
	 */
	@Override
	public CommonResponse<Boolean> checkSubLeaderIsExist(Long supplierId, String idCardNum) {
		return CommonResponse.error("网络问题，请稍后重试！");
	}

	@Override
	public CommonResponse<String> punishSupplierBatch(List<PunishVO> punishVOs) {
		return CommonResponse.error("网络问题，请稍后重试！");
	}

	@Override
	public CommonResponse<String> updateSupplierAndSubLeaderBatch(String updateParamsStr) {
		return CommonResponse.error("网络问题，请稍后重试！");
	}

	@Override
	public CommonResponse<SupplierDTO> getOneBySourceId(String sourceId) {
		return CommonResponse.error("网络问题，请稍后重试！");
	}

	@Override
	public CommonResponse<SupplierDTO> getOneByCode(String code) {
		return CommonResponse.error("网络问题，请稍后重试！");
	}
}
