package com.ejianc.foundation.supplier.api;

import com.ejianc.foundation.share.vo.PunishVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.hystrix.SupplierHystrix;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;



/**
 * 基础供应商rpc服务
 */
@FeignClient(name= "ejc-support-web", url="${common.env.feign-client-url}", path="ejc-share-web", fallback = SupplierHystrix.class)
public interface ISupplierApi {



	/**
	 * 供应商准入推送，生成企业供应商 适用于供应商本体推送
	 *
	 * @return supplyByte 是SupplierVO的json字符串生成的字节数组
	 */
	@PostMapping(value = "/api/supplierApi/pushSupplierToBaseStore")
	CommonResponse<String> pushSupplierToBaseStore(@RequestBody  SupplierVO supplierVO);

	/**
	 *  判断统一社会信用代码、身份证号是否重复
	 *
	 * @return
	 */
	@GetMapping(value = "/api/supplierApi/judgeTaxpayerNumIsRepeat")
	CommonResponse<String> judgeTaxpayerNumIsRepeat(@RequestParam(value = "taxpayerNum")  String taxpayerNum, @RequestParam(value = "personal") String personal);

	/**
	 * 供应商处置更新供应商库
	 */
	@PostMapping(value = "/api/supplierApi/punishSupplier")
	CommonResponse<String> punishSupplier(@RequestBody PunishVO punishVO);

	/**
	 * 移除供应商异常标签
	 */
	@GetMapping(value = "/api/supplierApi/returnSupplierToNormal")
	CommonResponse<String> returnSupplierToNormal(@RequestParam("supplierId") Long supplierId,
												  @RequestParam("gradeId") Long gradeId,
												  @RequestParam("gradeName") String gradeName);


	/**
	 * 供应商 评级更新供应商库
	 *
	 * @param supplierId 供应商id
	 * @param gradeId    评定等级id
	 * @param gradeName  评定等级名称
	 */
	@GetMapping(value = "/api/supplierApi/upgradeSupplier")
	CommonResponse<String> upgradeSupplier(@RequestParam("supplierId") Long supplierId,
												  @RequestParam("gradeId") Long gradeId,
												  @RequestParam("gradeName") String gradeName);

	/**
	 * 根据供应商id，查询供应商信息
	 */
	@GetMapping(value = "/api/supplierApi/getSupplierInfo")
	CommonResponse<SupplierVO> getSupplierInfo(@RequestParam("supplierId") Long supplierId);


	/**
	 * 根据供应商id，查询供应商是否真正协同成功
	 */
	@GetMapping(value = "/api/supplierApi/whetherSupplierCoo")
	CommonResponse<Boolean> whetherSupplierCoo(@RequestParam("supplierId") Long supplierId);


	/**
	 * 根据供应商税号 或者 名称 校验供应商是否一致
	 * 不一致，返回false，并提示信息不一致的信息
	 * 一致，返回true
	 */
	@GetMapping(value = "/api/supplierApi/checkTaxpayerNumOrNameIsSame")
	CommonResponse<Boolean> checkTaxpayerNumOrNameIsSame(@RequestParam("taxpayerNum") String taxpayerNum,@RequestParam("name") String name);

	/**
	 * 供方平台和施工方在一个平台情况下，供方租户查询施工方的供应商信息
	 * */
	@GetMapping("/api/supplierApi/getSupplierBySupplierTenantId")
	CommonResponse<SupplierDTO> getSupplierBySupplierTenantId(@RequestParam Long supplierTenantId);
}
