package com.ejianc.foundation.supplier.hystrix;

import com.ejianc.foundation.supplier.vo.PunishVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 大企业供应商rpc服务
 */
@Component
public class SupplierHystrix implements ISupplierApi {

	/**
	 * 供应商准入推送，生成企业供应商 适用于供应商本体推送
	 *
	 * @param supplierVO
	 * @return supplyByte 是SupplierVO的json字符串生成的字节数组
	 */
	@Override
	public CommonResponse<String> pushSupplierToBaseStore(SupplierVO supplierVO) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	/**
	 * 判断统一社会信用代码、身份证号是否重复
	 *
	 * @param taxpayerNum
	 * @param personal
	 * @return
	 */
	@Override
	public CommonResponse<String> judgeTaxpayerNumIsRepeat(String taxpayerNum, String personal) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	/**
	 * 供应商处置更新供应商库
	 *
	 * @param punishVO
	 */
	@Override
	public CommonResponse<String> punishSupplier(PunishVO punishVO) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	/**
	 * 移除供应商异常标签
	 *
	 * @param supplierId
	 * @param gradeId
	 * @param gradeName
	 */
	@Override
	public CommonResponse<String> returnSupplierToNormal(Long supplierId, Long gradeId, String gradeName,String sourceType) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	/**
	 * 供应商 评级更新供应商库
	 *
	 * @param supplierId 供应商id
	 * @param gradeId    评定等级id
	 * @param gradeName  评定等级名称
	 */
	@Override
	public CommonResponse<String> upgradeSupplier(Long supplierId, Long gradeId, String gradeName,String sourceType) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	/**
	 * 根据供应商id，查询供应商信息
	 *
	 * @param supplierId
	 */
	@Override
	public CommonResponse<SupplierVO> getSupplierInfo(Long supplierId) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	/**
	 * 根据供应商id，查询供应商是否真正协同成功
	 *
	 * @param supplierId
	 */
	@Override
	public CommonResponse<Boolean> whetherSupplierCoo(Long supplierId) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	/**
	 * 根据供应商税号 或者 名称 校验供应商是否一致
	 * 不一致，返回false，并提示信息不一致的信息
	 * 一致，返回true
	 *
	 * @param taxpayerNum
	 * @param name
	 */
	@Override
	public CommonResponse<Boolean> checkTaxpayerNumOrNameIsSame(String taxpayerNum, String name) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	/**
	 * 供方平台和施工方在一个平台情况下，供方租户查询施工方的供应商信息
	 *
	 * @param supplierTenantId
	 */
	@Override
	public CommonResponse<SupplierDTO> getSupplierBySupplierTenantId(Long supplierTenantId) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	/**
	 * 根据采购租户id，查询基础供应商id
	 *
	 * @param tenantId
	 */
	@Override
	public CommonResponse<List<Long>> getBaseSupplierIdByTenantId(Long tenantId) {
		return CommonResponse.error("网络问题， 查询失败。");
	}
}
