package com.ejianc.foundation.supplier.vo;

import com.ejianc.foundation.supplier.vo.util.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.util.ArrayList;
import java.util.List;


/**
 * 品牌库-品牌vo
 * 
 * @author generator
 * 
 */
public class BrandReportVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;
    
    private Long brandTypeId; // 品牌分类
    private String brandTypeName; // 品牌分类名称
    private String supplierName; // 供应商名称
    private String brandName; // 品牌名称
    private String logoUrl; // logo地址

    private List<ITreeNodeB> children;
    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return brandTypeId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public String getLogoUrl() {
        return logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public Long getBrandTypeId() {
        return brandTypeId;
    }

    public void setBrandTypeId(Long brandTypeId) {
        this.brandTypeId = brandTypeId;
    }

    public String getBrandTypeName() {
        return brandTypeName;
    }

    public void setBrandTypeName(String brandTypeName) {
        this.brandTypeName = brandTypeName;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }
}
