package com.ejianc.foundation.dataModel.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 数据模型主表
 * 
 * @author generator
 * 
 */
public class DataModelVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 模型编码
    private String name; // 模型名称
    private String dataSetIds; // 数据集id
    private String subTabParam; // 单据子表查询纬度，格式:"子表键值1:字段键值1,子表键值2:字段键值2"
    private String billParam; // 单据数据参数，查询纬度，数据来源于单据,格式:"字段1,字段2"
    private Integer modelType; // 数据模型类型：1、指标，2、报表
    private Integer sequence; // 排序
    

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ReferSerialTransfer(referCode="support-data-model-data-set")
    public String getDataSetIds() {
        return dataSetIds;
    }

    @ReferDeserialTransfer
    public void setDataSetIds(String dataSetIds) {
        this.dataSetIds = dataSetIds;
    }
    public String getSubTabParam() {
        return subTabParam;
    }

    public void setSubTabParam(String subTabParam) {
        this.subTabParam = subTabParam;
    }
    public String getBillParam() {
        return billParam;
    }

    public void setBillParam(String billParam) {
        this.billParam = billParam;
    }
    public Integer getModelType() {
        return modelType;
    }

    public void setModelType(Integer modelType) {
        this.modelType = modelType;
    }
    public Integer getSequence() {
        return sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }
    
}
