package com.ejianc.foundation.supplier.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 供应商准入---单位银行信息
 * 
 * @author generator
 * 
 */
public class BankVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long bankId; // 银行名称
    private String bankName; // 银行名称
    private String bankCode; // 账号
    private String address; // 开户行地址
    private Boolean defaultable; // 是否默认
    private Long pid; // 主表主键
    private Long categoryId; // 银行类别
    private String categoryName; // 银行类别名称
    private String bankAccount; // 户名

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    /**
     * 银行名称
     */
    @ReferSerialTransfer(referCode="support-bank")
    public Long getBankId() {
        return bankId;
    }

    /**
     * 银行名称
     */
    @ReferDeserialTransfer
    public void setBankId(Long bankId) {
        this.bankId = bankId;
    }
    /**
     * 银行名称
     */
    public String getBankName() {
        return bankName;
    }

    /**
     * 银行名称
     */
    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    /**
     * 账号
     */
    public String getBankCode() {
        return bankCode;
    }

    /**
     * 账号
     */
    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }
    /**
     * 开户行地址
     */
    public String getAddress() {
        return address;
    }

    /**
     * 开户行地址
     */
    public void setAddress(String address) {
        this.address = address;
    }
    /**
     * 是否默认
     */
    public Boolean getDefaultable() {
        return defaultable;
    }

    /**
     * 是否默认
     */
    public void setDefaultable(Boolean defaultable) {
        this.defaultable = defaultable;
    }
    /**
     * 主表主键
     */
    public Long getPid() {
        return pid;
    }

    /**
     * 主表主键
     */
    public void setPid(Long pid) {
        this.pid = pid;
    }
    
}
