package com.ejianc.foundation.supplier.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 供应商准入品牌子表
 * 
 * @author generator
 * 
 */
public class BrandVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long canInId; // 主表主键ID
    private Long brandTypeId; // 品牌分类
    private String brandTypeName; // 品牌分类名称
    private String brandName; // 品牌名称
    private String brandCode; // 商标注册号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date brandExpirationDate; // 商标有效期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date authorizeExpirationDate; // 授权有效期

    private List<ProductionVO> productionsList = new ArrayList<>(); // 产品信息子表

    public Long getCanInId() {
        return canInId;
    }

    public void setCanInId(Long canInId) {
        this.canInId = canInId;
    }
    @ReferSerialTransfer(referCode="MaterialCategory001")
    public Long getBrandTypeId() {
        return brandTypeId;
    }
    @ReferDeserialTransfer
    public void setBrandTypeId(Long brandTypeId) {
        this.brandTypeId = brandTypeId;
    }
    public String getBrandTypeName() {
        return brandTypeName;
    }

    public void setBrandTypeName(String brandTypeName) {
        this.brandTypeName = brandTypeName;
    }
    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }
    public String getBrandCode() {
        return brandCode;
    }

    public void setBrandCode(String brandCode) {
        this.brandCode = brandCode;
    }
    public Date getBrandExpirationDate() {
        return brandExpirationDate;
    }

    public void setBrandExpirationDate(Date brandExpirationDate) {
        this.brandExpirationDate = brandExpirationDate;
    }
    public Date getAuthorizeExpirationDate() {
        return authorizeExpirationDate;
    }

    public void setAuthorizeExpirationDate(Date authorizeExpirationDate) {
        this.authorizeExpirationDate = authorizeExpirationDate;
    }

    public List<ProductionVO> getProductionsList() {
        return productionsList;
    }

    public void setProductionsList(List<ProductionVO> productionsList) {
        this.productionsList = productionsList;
    }
}
