package com.ejianc.foundation.share.api;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.share.hystrix.MaterialHystrix;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialFuzzyMatchVO;
import com.ejianc.foundation.share.vo.MaterialPlusVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * 物资rpc服务
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-support-web", url="${common.env.feign-client-url}", path="ejc-support-web", fallback = MaterialHystrix.class)
public interface IMaterialApi {

	/**
	 * 根据物资名称、规格型号、计量单位、物料分类进行唯一性查询
	 *
	 * @param materialVO(name,spac,unitName,categoryId)
	 * @return
	 */
	@RequestMapping(value = "/api/materialApi/queryExitFlag",method = RequestMethod.POST)
	public CommonResponse<MaterialVO> queryExitFlag(@RequestBody MaterialVO materialVO);

	/**
	 * 根据编码查询物料分类详情
	 *
	 * @param code
	 * @param tenantId 租户Id
	 * @param count
	 * @return
	 */
	@GetMapping(value = "/api/materialApi/queryCategoryByCode")
	public CommonResponse<MaterialCategoryVO> queryCategoryByCode(@RequestParam(value = "code") String code);

	/**
	 * 根据父id询全部物料分类
	 *
	 * @param id
	 * @param tenantId 租户Id
	 * @param count
	 * @return
	 */
	@GetMapping(value = "/api/materialApi/queryCategoryListByPid")
	public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByPid(@RequestParam(value = "id") Long id);

	/**
	 * 根据ids查询上级全部分类
	 *
	 * @param ids
	 * @return
	 */
	@GetMapping(value = "/api/materialApi/queryCategoryListByChildren")
	CommonResponse<List<MaterialCategoryVO>> queryCategoryListByChildren(@RequestParam(value = "ids") List<Long> ids);

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/10/19 根据sourceId查询物资
	 * @Description queryMaterialBySourceId
	 * @Param [sourceId]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.share.vo.MaterialVO>
	 */
	@GetMapping(value = "/api/materialApi/queryMaterialBySourceId")
	CommonResponse<MaterialVO> queryMaterialBySourceId(@RequestParam(value = "sourceId") String sourceId);

	/**
	 * @Author liyj
	 * @Date 2020/10/29 根据ids查询物资列表（包括物资来源id，物资分类来源id）
	 * @Param [ids]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.share.vo.MaterialVO>
	 */
	@GetMapping(value = "/api/materialApi/queryMaterialByIds")
	CommonResponse<List<MaterialVO>> queryMaterialByIds(@RequestParam(value = "ids") List<Long> ids);

	/**
	 * 根据主键查询物料分类详情
	 * @Author zhangwx
	 * @param id
	 * @return
	 */
	@GetMapping(value = "/api/materialApi/queryCategoryById")
	CommonResponse<MaterialCategoryVO> queryCategoryById(@RequestParam(value = "id") Long id);

	/***
	 * @description: 根据innercode查询物资
	 *
	 * @param params innerCode 父类id  categoryName 分类名称模糊查询
	 * @return: com.ejianc.framework.core.response.CommonResponse<java.util.List < com.ejianc.foundation.share.vo.MaterialCategoryVO>>
	 * @author songlx
	 * @date: 2021/9/10
	 */
	@PostMapping("/api/materialApi/queryListByInnerCode")
	CommonResponse<List<MaterialCategoryVO>> queryListByInnerCode(@RequestBody Map<String, Object> params);

	/***
	 * @description: 根据物资名称查询物资
	 *
	 * @author zhangwx
	 * @date: 2021/9/16
	 */
	@GetMapping("/api/materialApi/queryMaterialListByNames")
	CommonResponse<List<MaterialVO>> queryMaterialListByNames(@RequestParam(value = "nameList") List<String> nameList);


	/***
	 * @description: 根据物资名称查询物资
	 *
	 * @author zhangwx
	 * @date: 2021/9/16
	 */
	@PostMapping("/api/materialApi/queryMaterialsByNames")
	@ResponseBody
	CommonResponse<List<MaterialVO>> queryMaterialsByNames(@RequestBody List<String> nameList);

	/**
	 * 根据物资名称、规格型号、计量单位 查询
	 *
	 * @param materialVO(name,spac,unitName)
	 *
	 * @return
	 */
	@RequestMapping(value = "/api/materialApi/queryMaterialList", method = RequestMethod.POST)
	public CommonResponse<List<MaterialVO>> queryMaterialList(@RequestBody MaterialVO materialVO);


	/**
	 * 校验档案是否存在
	 *
	 * @param materialFuzzyMatchVO 材料设备模糊匹配VO
	 *
	 * @return {@link CommonResponse}<{@link MaterialFuzzyMatchVO}>
	 */
	@PostMapping(value = "/api/materialApi/checkArchive")
	CommonResponse<MaterialFuzzyMatchVO> checkArchive(@RequestBody MaterialFuzzyMatchVO materialFuzzyMatchVO);

	/**
	 * 模糊匹配数量
	 *
	 * @param materialFuzzyMatchVO 材料设备模糊匹配VO
	 *
	 * @return {@link CommonResponse}<{@link MaterialFuzzyMatchVO}>
	 */
	@PostMapping(value = "/api/materialApi/fuzzyMatchNumber")
	CommonResponse<MaterialFuzzyMatchVO> fuzzyMatchNumber(@RequestBody MaterialFuzzyMatchVO materialFuzzyMatchVO);

	/**
	 * 模糊匹配分页查询
	 *
	 * @param materialFuzzyMatchVO 材料设备模糊匹配VO
	 *
	 * @return {@link CommonResponse}<{@link IPage}<{@link MaterialPlusVO}>>
	 */
	@PostMapping(value = "/api/materialApi/fuzzyMatchQueryPage")
	CommonResponse<IPage<MaterialPlusVO>> fuzzyMatchQueryPage(@RequestBody MaterialFuzzyMatchVO materialFuzzyMatchVO);


	/**
	 * 批量插入档案
	 *
	 * @param materialVOMap 材料设备VO
	 *
	 * @return {@link CommonResponse}<{@link Map}<{@link String}, {@link MaterialVO}>>
	 */
	@PostMapping(value = "/api/materialApi/batchInsertArchive")
	CommonResponse<Map<String, MaterialVO>> batchInsertArchive(@RequestBody Map<String, MaterialVO> materialVOMap);

	/**
	 * 根据编码集合查询档案列表
	 *
	 * @param codeList
	 * @return
	 */
	@GetMapping(value = "/api/materialApi/queryMaterialListByCodes")
	CommonResponse<List<MaterialCategoryVO>> queryMaterialListByCodes(@RequestParam(value = "codeList") List<String> codeList);
}
