package com.ejianc.foundation.supplier.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;


/**
 * 供应商准入财报子表
 * 
 * @author generator
 * 
 */
public class FinanceReportVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long pid; // 主表主键ID
    private String year; // 年份
    private Long currencyId; // 货币
    private String currencyName; // 货币名称
    private BigDecimal receiveIn; // 营业收入(万元)
    private BigDecimal profit; // 利润(万元)
    private String memo; // 备注
    private String cashIn; // 生产经营活动现金流入
    private String cashInE; // 生产经营活动现金流净额

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getCurrencyId() {
        return currencyId;
    }
    @ReferDeserialTransfer
    public void setCurrencyId(Long currencyId) {
        this.currencyId = currencyId;
    }
    public String getCurrencyName() {
        return currencyName;
    }

    public void setCurrencyName(String currencyName) {
        this.currencyName = currencyName;
    }
    public BigDecimal getReceiveIn() {
        return receiveIn;
    }

    public void setReceiveIn(BigDecimal receiveIn) {
        this.receiveIn = receiveIn;
    }
    public BigDecimal getProfit() {
        return profit;
    }

    public void setProfit(BigDecimal profit) {
        this.profit = profit;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getCashIn() {
        return cashIn;
    }

    public void setCashIn(String cashIn) {
        this.cashIn = cashIn;
    }

    public String getCashInE() {
        return cashInE;
    }

    public void setCashInE(String cashInE) {
        this.cashInE = cashInE;
    }
}
