package com.ejianc.foundation.support.vo;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.io.Serializable;

/**
 * 编码参数
 * 
 * @author guoming
 *
 */
public class BillCodeParam implements Serializable {
	
	public static BillCodeParam build(String ruleCode, Long tenantId, BaseVO baseVO) {
		BillCodeParam param = new BillCodeParam();
		param.setTenantId(tenantId); 
		param.setRuleCode(ruleCode);
		if (baseVO != null) {
			param.setBillDetail(JSONObject.parseObject(JSONObject.toJSONString(baseVO)));
		}
		return param;
	}

	public static BillCodeParam build(String ruleCode, Long waterBasicId, Long tenantId, BaseVO baseVO) {
		BillCodeParam param = new BillCodeParam();
		param.setTenantId(tenantId); 
		param.setWaterBasicId(waterBasicId);     
		param.setRuleCode(ruleCode);
		if (baseVO != null) {
			param.setBillDetail(JSONObject.parseObject(JSONObject.toJSONString(baseVO)));
		}
		return param;
	}
	
	public static BillCodeParam build(String ruleCode, Long tenantId, JSONObject paramJson) {
		BillCodeParam param = new BillCodeParam();
		param.setTenantId(tenantId);
		param.setRuleCode(ruleCode);
		param.setBillDetail(paramJson);
		return param;
	}

	public static BillCodeParam build(String ruleCode, Long waterBasicId, Long tenantId, JSONObject paramJson) {
		BillCodeParam param = new BillCodeParam();
		param.setWaterBasicId(waterBasicId);
		param.setTenantId(tenantId);
		param.setRuleCode(ruleCode);
		param.setBillDetail(paramJson);
		return param;
	}

	private static final long serialVersionUID = 1L;

	/**
	 * 规则编号
	 */
	private String ruleCode;

	/**
	 * 流水依据ID
	 */
	private Long waterBasicId;

	/**
	 * 租户ID
	 */
	private Long tenantId;

	/**
	 * 内容
	 */
	private JSONObject billDetail;

	public String getRuleCode() {
		return ruleCode;
	}

	public void setRuleCode(String ruleCode) {
		this.ruleCode = ruleCode;
	}

	public Long getWaterBasicId() {
		return waterBasicId;
	}

	public void setWaterBasicId(Long waterBasicId) {
		this.waterBasicId = waterBasicId;
	}

	public Long getTenantId() {
		return tenantId;
	}

	public void setTenantId(Long tenantId) {
		this.tenantId = tenantId;
	}

	public JSONObject getBillDetail() {
		return billDetail;
	}

	public void setBillDetail(JSONObject billDetail) {
		this.billDetail = billDetail;
	}

}
