package com.ejianc.foundation.share.api;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import com.ejianc.foundation.share.hystrix.SyncShareHystrix;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * 水电八局同步rpc服务
 * 
 * @author cJ
 *
 */
@FeignClient(name= "ejc-support-web", url="${common.env.feign-client-url}", path="ejc-support-web", fallback = SyncShareHystrix.class)
public interface ISyncShareApi {

	/**
	 * 同步供方数据
	 *
	 * @param 
	 * @return	
	 */
	@PostMapping(value = "/api/sync/syncSupplierList")
	public CommonResponse<String> syncSupplierList(@RequestBody List<SupplierVO> supplierList);

}
