package com.ejianc.foundation.share.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonIgnore;

import java.util.List;

/**
 * @description: PSRMResponse
 * @author songlx
 * @date 2025/3/25
 * @version 1.0
 */
public class PSRMResponse {

    public static String SUCCESS_RETURNCODE = "0";

    private String returncode = "0";

    private List<Object> data;

    private List<String> warnmsg;


    public String getReturncode() {
        return returncode;
    }

    public void setReturncode(String returncode) {
        this.returncode = returncode;
    }

    public List<Object> getData() {
        return data;
    }

    public void setData(List<Object> data) {
        this.data = data;
    }

    public List<String> getWarnmsg() {
        return warnmsg;
    }

    public void setWarnmsg(List<String> warnmsg) {
        this.warnmsg = warnmsg;
    }

    public static PSRMResponse success() {
        PSRMResponse result = new PSRMResponse();
        result.setReturncode(SUCCESS_RETURNCODE);
        return result;
    }

    @JsonIgnore
    public boolean isSuccess() {
        return SUCCESS_RETURNCODE.equals(this.getReturncode());
    }

    public String getPSRMCode() {
        if (this.isSuccess()) {
            Object o = this.getData().get(0);
            JSONObject jsonObject = (JSONObject) JSONObject.toJSON(o);
            jsonObject.getString("f_code");
        }
        return null;
    }
}
