package com.ejianc.foundation.share.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import okhttp3.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

/**
 * @description: PSRMRestUtil 华康数据中台util
 * @author songlx
 * @date 2025/3/25
 * @version 1.0
 */
@Component
public class PSRMRestUtil {

    private static final Logger logger = LoggerFactory.getLogger(PSRMRestUtil.class);

    public static String SUCCESS_RETURNCODE = "0";

    private static final OkHttpClient HTTP_CLIENT = new OkHttpClient().newBuilder()
            .connectTimeout(10, TimeUnit.MINUTES)
            .readTimeout(10, TimeUnit.MINUTES)
            .writeTimeout(10, TimeUnit.MINUTES)
            .build();
    private static final MediaType mediaType = MediaType.parse("application/json");

    @Value("${psrm.restUrl:http://192.168.20.190/upms/rest}")
    private String restUrl;

    @Value("${psrm.userCode:admin}")
    private String userCode;

    @Value("${psrm.password:698d51a19d8a121ce581499d7b701668}")
    private String password;

    @Value("${psrm.runMode:false}")
    private Boolean runMode;


    // http://192.168.20.190/upms/rest?com_id=0&method=upms.user.login&token=undefined
    // http://192.168.20.190/psrm/rest?com_id=1&method=psrm.supplier.add&token=


    public PSRMResponse postDisableOrDelReq(String fCode, String methodName) {
        JSONObject objDel = new JSONObject();
        objDel.put("f_code", fCode);
        return postReq(objDel, methodName);
    }

    public PSRMResponse postReq(JSONObject content, String methodName, String token) {
        try {
            logger.info("======================={}===========================================", methodName);
            String url = restUrl + "/psrm/rest?com_id=1&method=" + methodName + "&token=" + token;
            logger.info("请求url：{}", url);
            logger.info("请求报文：{}", content.toJSONString());
            RequestBody body = RequestBody.create(mediaType, content.toJSONString());
            Request request = new Request.Builder()
                    .url(url)
                    .method("POST", body)
                    .addHeader("Content-Type", "application/json;charset=utf-8")
                    .build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            String resBody = response.body().string();
            PSRMResponse resp = JSON.parseObject(resBody, PSRMResponse.class);
            logger.info("原始响应: {}, {}", resBody, JSON.toJSONString(resp));
            logger.info("响应: {}", JSON.toJSONString(resp));
            logger.info("======================={}===========================================", methodName);
            return resp;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }


    public PSRMResponse postReq(JSONObject content, String methodName) {
        return postReq(content, methodName, getToken());
    }


    public String getToken() {
        try {
            JSONObject content = new JSONObject();
            content.put("f_code", userCode);
            content.put("f_password", password);
            content.put("orgId", "1");
            RequestBody body = RequestBody.create(mediaType, content.toJSONString());
            Request request = new Request.Builder()
                    .url(restUrl + "/upms/rest?com_id=0&method=upms.user.login&token=undefined")
                    .method("POST", body)
                    .addHeader("Content-Type", "application/json;charset=utf-8")
                    .build();
            Response response = HTTP_CLIENT.newCall(request).execute();

            String resBody = response.body().string();
            JSONObject json = JSON.parseObject(resBody);
            if (!"0".equals(json.get("returncode"))) {
                throw new BusinessException("获取数据中台Token失败：" + json.getString("data"));
            }
            // 获取 token
            String token = json.getJSONObject("data")
                    .getJSONObject("upms_user")
                    .getString("token");
            logger.info("PSRM Token: {}", token);
            return token;
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Boolean isRunMode() {
        return runMode;
    }

}
