package com.ejianc.foundation.support.api;

import com.ejianc.foundation.support.hystrix.BillCodeHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 自动编码获取rpc服务
 * 
 * @author cJ
 *
 */
@FeignClient(name= "ejc-support-web", url="${common.env.feign-client-url}", path="ejc-support-web", fallback = BillCodeHystrix.class)
public interface IBillCodeApi {

	/**
	 * 根据编码规则主键ID获取按对应规则生成的编码
	 *
	 * @param code
	 * @param tenantId 租户Id
	 * @return
	 */
	@GetMapping(value = "/api/billCodeApi/getByCode")
	public CommonResponse<String> getCodeBatchByRuleCode(@RequestParam(value = "code") String code, @RequestParam(value = "tenantId") Long tenantId);

	/**
	 * 根据编码规则主键ID获取按对应规则生成的编码(批量)
	 *
	 * @param code
	 * @param tenantId 租户Id
	 * @param count
	 * @return
	 */
	@GetMapping(value = "/api/billCodeApi/getCodeBatchByCode")
	public CommonResponse<List<String>> getCodeBatchByRuleCode(@RequestParam(value = "code") String code,
															   @RequestParam(value = "tenantId") Long tenantId,
															   @RequestParam(value = "count") int count);
}
