package com.ejianc.foundation.support.api;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.ejianc.foundation.support.hystrix.ModuleHystrix;
import com.ejianc.foundation.support.vo.ModuleVO;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * 模块rpc服务
 * 
 * @author guoming
 *
 */
@FeignClient(name= "ejc-support-web", url="${common.env.feign-client-url}", path="ejc-support-web", fallback = ModuleHystrix.class)
public interface IModuleApi {

	/**
	 * 根据父ID查询其下所有节点
	 * 
	 * @param moduleId
	 * @return
	 */
	@RequestMapping(value = "/api/module/getListByPid", method=RequestMethod.GET)
	public CommonResponse<List<ModuleVO>> queryModuleListByPid(@RequestParam(value="moduleId", required=true) Long moduleId);

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/9/15 根据模块id查询模块信息
	 * @Description getModuleById
	 * @Param [moduleId]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.support.vo.ModuleVO>
	 */
	@RequestMapping(value = "/api/module/getModuleById", method=RequestMethod.GET)
	public CommonResponse<ModuleVO> getModuleById(@RequestParam(value="moduleId", required=true) Long moduleId) ;

	@PostMapping(value = "/api/module/refreshModuleCache")
	public CommonResponse<String> refreshModuleCache();
}
