package com.ejianc.foundation.supplier.api;

import com.ejianc.foundation.supplier.hystrix.SupplierCategoryHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name= "ejc-support-web", url="${common.env.feign-client-url}", path="ejc-support-web", fallback = SupplierCategoryHystrix.class)
public interface ISupplierCategoryApi {

    @RequestMapping(value = "/api/supplierAccountApi/findChildrenByParentId", method = RequestMethod.GET)
    CommonResponse<List<Long>> findChildrenByParentId(@RequestParam("categoryId")Long categoryId);

}
