package com.ejianc.foundation.support.api;

import com.ejianc.foundation.support.hystrix.ParamConfigHystrix;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @Author mrsir_wxp
 * @Date 2021/1/15  参数配置 api
 * @Description IParamConfigApi
 */

@FeignClient(name= "ejc-support-web", url="${common.env.feign-client-url}", path="ejc-support-web", fallback = ParamConfigHystrix.class)
public interface IParamConfigApi {

	/**
	 * @Author mrsir_wxp
	 * @Date 2021/1/15  根据参数设置编码，查询参数值
	 * @Description getByCode
	 * @Param [code]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.support.vo.DefdocDetailVO>
	 */
	@RequestMapping(value = "/api/param/config/getByCode", method=RequestMethod.GET)
	CommonResponse<ParamRegisterSetVO> getByCode(@RequestParam(value="code") String code);


	/**
	 * @Author mrsir_wxp
	 * @Date 2021/5/7 根据单据参数编码，查询单据参数控制参数
	 * @Description   此方法已不可使用 请使用下面的方法
	 * @Param
	 * @Return
	 */
	@Deprecated
	@RequestMapping(value = "/api/param/config/getBillParamByCode", method=RequestMethod.GET)
	CommonResponse<BillParamVO> getBillParamByCode(@RequestParam(value="code") String code);

	/**
	 * @Author mrsir_wxp
	 * @Date 2022/6/30 根据单据参数编码和给的组织id，查询单据参数控制参数
	 * @Description
	 * @Param code 参数编码
	 * @Param orgId 组织id
	 * @Return 本级+上级组织配置的该单据参数各个值以及各自组织和控制规则的列表
	 */
	@RequestMapping(value = "/api/param/config/getBillParamByCodeAndOrgId", method=RequestMethod.GET)
	CommonResponse<List<BillParamVO>> getBillParamByCodeAndOrgId(@RequestParam(value="code") String code,@RequestParam(value="orgId") Long orgId);
}
