package com.ejianc.foundation.share.api;

import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.foundation.share.hystrix.ZjkjProjectHystrix;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * 中建科技项目rpc服务
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-support-web", url="${common.env.feign-client-url}", path="ejc-support-web", fallback = ZjkjProjectHystrix.class)
public interface IZjkjProjectApi {

    /**
     * 根据项目Id查询项目信息
     *
     * @param id
     * @return
     */
	@GetMapping("/api/zjkj/projectApi/queryDetailById")
	CommonResponse<ProjectVO> queryDetailById(@RequestParam(value = "id") Long id);

    /**
     * @Description saveOrUpdate 新增或者修改
     */
	@PostMapping("/api/zjkj/projectApi/saveProject")
	CommonResponse<ProjectVO> saveProject(@RequestBody ProjectVO projectVO);

    /**
     * 根据项目Id查询项目信息
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/api/zjkj/projectApi/queryDetailByparam", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectVO> queryDetailByparam(@RequestBody Map<String,Object> param);

	@GetMapping(value = "/api/zjkj/projectApi/findProjectNum")
	CommonResponse<Integer> findProjectNum(@RequestParam(value="section") String section);

    /**
     * 查询中建科技下的所有项目
     * @param section
     * @return
     */
    @GetMapping(value = "/api/zjkj/projectApi/findProjectAll")
    CommonResponse<List<ProjectVO>> findProjectAll();

    /**
     * 根据ids查询项目详情
     *
     * @param ids
     * @return
     */
    @PostMapping(value = "/api/zjkj/projectApi/queryProjectArray")
    CommonResponse<JSONArray> queryProjectArray(@RequestBody List<Long> ids);
    /**
     * 根据条件查询中建科技下的所有项目
     * @param
     * @return
     */
    @PostMapping(value = "/api/zjkj/projectApi/queryProjects")
    CommonResponse<List<ProjectVO>> queryProjects(@RequestBody QueryParam param);

    /**
     * 根据条件查询项目信息
     * @return
     */
    @PostMapping(value = "/api/zjkj/projectApi/queryProjectsByParma")
    CommonResponse<List<ProjectVO>> queryProjectsByParma(@RequestBody QueryParam param);

    /**
     * 根据条件查询中建科技下的所有项目
     * @param
     * @return
     */
    @PostMapping(value = "/api/zjkj/projectApi/queryArray")
    CommonResponse<JSONArray> queryArray(@RequestBody QueryParam param);

    /**
     * 根据项目部id查询项目信息
     * @param projectDepartmentId
     * @return
     */
    @GetMapping("/api/zjkj/projectApi/queryProjectByProjectDepartmentId")
    CommonResponse<ProjectVO> queryProjectByProjectDepartmentId(@RequestParam(value = "projectDepartmentId") Long projectDepartmentId);

    /**
     * 查询当前组织下的所有启用和在建的项目
     * @param orgId
     * @return
     */
    @GetMapping("/api/zjkj/projectApi/queryProjectsByOrgId")
    CommonResponse<List<ProjectVO>> queryProjectsByOrgId(@RequestParam("orgId") Long orgId);

    /**
     * 查询当前组织下的所有启用和在建的项目
     * @param orgId
     * @return
     */
    @GetMapping("/api/zjkj/projectApi/queryArrayByOrgId")
    CommonResponse<JSONArray> queryArrayByOrgId(@RequestParam("orgId") Long orgId);
}
