package com.ejianc.foundation.sync.api;

import com.ejianc.foundation.sync.vo.*;
import com.ejianc.foundation.sync.hystrix.ZjwjSyncMaterialHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Date;
import java.util.List;

/**
 * 同步数据的rpc服务
 *
 * @author liyongjia
 *
 */
@FeignClient(name= "ejc-support-web", url="${common.env.feign-client-url}", path="ejc-support-web", fallback = ZjwjSyncMaterialHystrix.class)
public interface IZjwjSyncShareApi {


	//获取上次同步物资时间
	@GetMapping(value = "api/zjwjsync/queryLastMaterialSyncTime")
	public CommonResponse<Date> queryLastMaterialSyncTime(@RequestParam(required = false) String params);

	/**
	 * 物料
	 *
	 * @param materialVOS
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncMaterialList")
	public CommonResponse<String> syncMaterialList(List<SyncMaterialVO> materialVOS);

	//获取上次同步物资分类时间
	@GetMapping(value = "api/zjwjsync/queryLastMatCtrySyncTime")
	public CommonResponse<Date> queryLastMatCtrySyncTime(@RequestParam(required = false) String params);

	/**
	 * 物料分类
	 *
	 * @param materialCategoryVOS
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncMaterialCategoryList")
	public CommonResponse<String> syncMaterialCategoryList(List<SyncMaterialCategoryVO> materialCategoryVOS);


	//获取上次同步物料关系时间
	@GetMapping(value = "api/zjwjsync/queryLastMatRelationSyncTime")
	public CommonResponse<Date> queryLastMatRelationSyncTime(@RequestParam(required = false) String params);

	/**
	 * 物料组织分配
	 *
	 * @param materialRelationVOS
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncMaterialRelationList")
	public CommonResponse<String> syncMaterialRelationList(List<SyncMaterialRelationVO> materialRelationVOS);

	/**
	 * 物料组织分配入库
	 *
	 * @param tenantId
	 * @return
	 */
	@GetMapping(value = "api/zjwjsync/syncMaterialRelationToDb")
	public CommonResponse<String> syncMaterialRelationToDb(@RequestParam(required = false) String tenantId, @RequestParam(required = false) String systemId);

	//获取上次同步供应商时间
	@GetMapping(value = "api/zjwjsync/queryLastSupplierSyncTime")
	public CommonResponse<Date> queryLastSupplierSyncTime(@RequestParam(required = false) String params);

	/**
	 * 供应商
	 *
	 * @param syncSupplierVOS
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncSupplierList")
	public CommonResponse<String> syncSupplierList(List<SyncSupplierVO> syncSupplierVOS);

	//获取上次同步供应商分类时间
	@GetMapping(value = "api/zjwjsync/queryLastSupCatySyncTime")
	public CommonResponse<Date> queryLastSupCatySyncTime(@RequestParam(required = false) String params);

	/**
	 * 供应商分类
	 *
	 * @param syncSupplierCategoryVOS
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncSupplierCategoryList")
	public CommonResponse<String> syncSupplierCategoryList(List<SyncSupplierCategoryVO> syncSupplierCategoryVOS);
}
