package com.ejianc.foundation.share.vo;

import java.io.Serializable;
import java.util.Map;

/**
 * 材料设备模糊匹配VO
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
public class MaterialFuzzyMatchVO implements Serializable {
	private static final long serialVersionUID = 1777190481136640371L;

	/** 当前页码 */
	protected Long current = 1L;
	/** 条数 */
	protected Long size = 10L;
	/** 清单名称 */
	private String name;
	/** 费用类型 */
	private Integer type;
	/** 分类名称 */
	private String categoryName;
	/** 规格型号 */
	private String spec;
	/** 单位名称 */
	private String unitName;
	/** 清单名称模糊 */
	private String fuzzyName;
	/** 规格型号模糊 */
	private String fuzzySpec;
	/** 单位名称模糊 */
	private String fuzzyUnitName;

	/** 材料分类 */
	private Map<String, Boolean> materialCategoryMap; // key-材料档案名称
	/** 设备分类 */
	private Map<String, Boolean> equipmentCategoryMap; // key-设备档案名称
	/** 模糊匹配结果 */
	private Map<String, MaterialPlusVO> fuzzyMatchMap;

	public Long getCurrent() {
		return current;
	}

	public void setCurrent(Long current) {
		this.current = current;
	}

	public Long getSize() {
		return size;
	}

	public void setSize(Long size) {
		this.size = size;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getCategoryName() {
		return categoryName;
	}

	public void setCategoryName(String categoryName) {
		this.categoryName = categoryName;
	}

	public String getSpec() {
		return spec;
	}

	public void setSpec(String spec) {
		this.spec = spec;
	}

	public String getUnitName() {
		return unitName;
	}

	public void setUnitName(String unitName) {
		this.unitName = unitName;
	}

	public String getFuzzyName() {
		return fuzzyName;
	}

	public void setFuzzyName(String fuzzyName) {
		this.fuzzyName = fuzzyName;
	}

	public String getFuzzySpec() {
		return fuzzySpec;
	}

	public void setFuzzySpec(String fuzzySpec) {
		this.fuzzySpec = fuzzySpec;
	}

	public String getFuzzyUnitName() {
		return fuzzyUnitName;
	}

	public void setFuzzyUnitName(String fuzzyUnitName) {
		this.fuzzyUnitName = fuzzyUnitName;
	}

	public Map<String, Boolean> getMaterialCategoryMap() {
		return materialCategoryMap;
	}

	public void setMaterialCategoryMap(Map<String, Boolean> materialCategoryMap) {
		this.materialCategoryMap = materialCategoryMap;
	}

	public Map<String, Boolean> getEquipmentCategoryMap() {
		return equipmentCategoryMap;
	}

	public void setEquipmentCategoryMap(Map<String, Boolean> equipmentCategoryMap) {
		this.equipmentCategoryMap = equipmentCategoryMap;
	}

	public Map<String, MaterialPlusVO> getFuzzyMatchMap() {
		return fuzzyMatchMap;
	}

	public void setFuzzyMatchMap(Map<String, MaterialPlusVO> fuzzyMatchMap) {
		this.fuzzyMatchMap = fuzzyMatchMap;
	}
}
