package com.ejianc.foundation.supplier.util;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ContractPerformanceStateEnum {

    /**
     * 触发规则：
     *      单据提交，自由态或审批中的状态都是未签订
     * 数据规则：
     *      金额占用目标成本、总计划或关联业务单据
     */
    未签订("1", "未签订"),

    /**
     * 触发规则：
     *      未集成电子签章的单据审批完成变为履约中，
     *      集成电子签章的签章完成后状态变为履约中
     *      用印审批  审批通过的变为履约中
     *  数据规则：
     *       金额回写和占用责任成本、总计划或关联业务单据
     */
    履约中("2", "履约中"),

    /**
     * 触发规则：
     *      最终结算完成后合同状态变为已终止
     * 数据规则：
     *      已终止的合同不允许签订补充协议、不允许变更、不允许发生过程结算，数据回写到合同台账，已终止合同的累计值占用
     *      目标成本值。
     */
    已终止("3", "已终止"),

    /**
     * 触发规则：
     *      发生异常终止的情况，双方合同解除的情况、合同不履行，发起解除的单据
     * 数据规则：
     *      不可再发生新的变更、补充协议、结算，已发生的结算、付款申请处于关闭状态，不可发生后续业务：提交、审批
     */
    已作废("4", "已作废"),

    /**
     * 触发规则：
     *      由于供应商纠纷产生的暂时不付款，通过合同冻结单来触发，履约中能冻结，能取消冻结走审批
     * 数据规则：
     *      不可再发生新的变更、补充协议、结算，已发生的结算、付款申请处于关闭状态，不可发生后续业务：提交、审批
     */
    已冻结("5", "已冻结"),

    /**
     * 触发规则：
     *      最后一次付款完成，合同状态变为已结束
     * 数据规则：
     *      已结束状态的合同不允许参照合同、不允许签订补充协议、不允许变更、不允许发生过程结算，数据回写到合同台账，
     *      已结束的合同累计值占用目标成本值
     */
    已结束("6", "已结束");

    private String stateCode;
    private String stateName;

    ContractPerformanceStateEnum(String stateCode, String stateName) {
        this.stateCode = stateCode;
        this.stateName = stateName;
    }

    public String getStateCode() {
        return stateCode;
    }

    public void setStateCode(String stateCode) {
        this.stateCode = stateCode;
    }

    public String getStateName() {
        return stateName;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    private static Map<String, ContractPerformanceStateEnum> enumMap = new HashMap<>();

    static {
        enumMap = EnumSet.allOf(ContractPerformanceStateEnum.class).stream().collect(Collectors.toMap(ContractPerformanceStateEnum::getStateCode, Function.identity(), (k1, k2) -> k2));
    }

    public static ContractPerformanceStateEnum getByStateCode(String stateCode) {
        return enumMap.get(stateCode);
    }
}
