package com.ejianc.foundation.supplier.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 供应商库
 * 
 * @author generator
 * 
 */
public class SupplierVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String code; // 供应商编号
    private String name; // 供应商名称/个人姓名
    private String personal; // 个人：p，企业：e
    private String orgName; // 申请单位
    private Long orgId; // 申请单位id
    private Long enterpriseNature; // 企业性质id
    private String enterpriseNatureName; // 企业性质名称
    private String taxNum; // 纳税人识别号/身份证号
    private String connectPerson; // 联系人
    private String legalPerson; // 法人代表/别名/联系人
    private String legalPhone; // 法人电话/联系电话
    private String area; // 所在地区
    private String areaName; // 所在地区名称
    private String address; // 企业地址
    private String gradeName; // 供应商等级
    private String businessRange; // 经营范围
    private String memo; // 备注

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date timeOut; // 营业执照有效期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date registerDate; // 注册日期
    private BigDecimal registerMny; // 注册资金
    private BigDecimal turnover; // 年营业额
    private String productionName; // 产品名称
    private String productionTypeId; // 产品类型id
    private String productionTypeName; // 产品类型名称
    private String proMemo; // 产品信息备注
    private String resourceState; // 资源状况
    private String productionQuality; // 产品、质量
    private String tecState; // 技术（产品）服务状况
    private String toBuyThings; // 拟采购产品
    private String investigatePerson; // 调查人
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date investigateDate; // 调查时间
    private Boolean groupBlack; // 是否集团拉黑
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date groupLastTime; // 集团拉黑持续截止时间
    private String blackOrgIds; // 拉黑组织id集合
    private String blackOrgNames; // 拉黑组织名称集合
    private BigDecimal yearScore; // 年度得分
    private List<SupplierBankVO> supplierBankList = new ArrayList<>(); // 供应商银行信息
    private List<SupplierCertVO> supplierCertList = new ArrayList<>(); // 供应商证件

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getPersonal() {
        return personal;
    }

    public void setPersonal(String personal) {
        this.personal = personal;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getEnterpriseNature() {
        return enterpriseNature;
    }

    @ReferDeserialTransfer
    public void setEnterpriseNature(Long enterpriseNature) {
        this.enterpriseNature = enterpriseNature;
    }
    public String getEnterpriseNatureName() {
        return enterpriseNatureName;
    }

    public void setEnterpriseNatureName(String enterpriseNatureName) {
        this.enterpriseNatureName = enterpriseNatureName;
    }
    public String getTaxNum() {
        return taxNum;
    }

    public void setTaxNum(String taxNum) {
        this.taxNum = taxNum;
    }
    public String getConnectPerson() {
        return connectPerson;
    }

    public void setConnectPerson(String connectPerson) {
        this.connectPerson = connectPerson;
    }
    public String getLegalPerson() {
        return legalPerson;
    }

    public void setLegalPerson(String legalPerson) {
        this.legalPerson = legalPerson;
    }
    public String getLegalPhone() {
        return legalPhone;
    }

    public void setLegalPhone(String legalPhone) {
        this.legalPhone = legalPhone;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public String getGradeName() {
        return gradeName;
    }

    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }
    public String getBusinessRange() {
        return businessRange;
    }

    public void setBusinessRange(String businessRange) {
        this.businessRange = businessRange;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getTimeOut() {
        return timeOut;
    }

    public void setTimeOut(Date timeOut) {
        this.timeOut = timeOut;
    }
    public Date getRegisterDate() {
        return registerDate;
    }

    public void setRegisterDate(Date registerDate) {
        this.registerDate = registerDate;
    }
    public BigDecimal getRegisterMny() {
        return registerMny;
    }

    public void setRegisterMny(BigDecimal registerMny) {
        this.registerMny = registerMny;
    }
    public BigDecimal getTurnover() {
        return turnover;
    }

    public void setTurnover(BigDecimal turnover) {
        this.turnover = turnover;
    }
    public String getProductionName() {
        return productionName;
    }

    public void setProductionName(String productionName) {
        this.productionName = productionName;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public String getProductionTypeId() {
        return productionTypeId;
    }
    @ReferDeserialTransfer
    public void setProductionTypeId(String productionTypeId) {
        this.productionTypeId = productionTypeId;
    }
    public String getProductionTypeName() {
        return productionTypeName;
    }

    public void setProductionTypeName(String productionTypeName) {
        this.productionTypeName = productionTypeName;
    }
    public String getProMemo() {
        return proMemo;
    }

    public void setProMemo(String proMemo) {
        this.proMemo = proMemo;
    }
    public String getResourceState() {
        return resourceState;
    }

    public void setResourceState(String resourceState) {
        this.resourceState = resourceState;
    }
    public String getProductionQuality() {
        return productionQuality;
    }

    public void setProductionQuality(String productionQuality) {
        this.productionQuality = productionQuality;
    }
    public String getTecState() {
        return tecState;
    }

    public void setTecState(String tecState) {
        this.tecState = tecState;
    }
    public String getToBuyThings() {
        return toBuyThings;
    }

    public void setToBuyThings(String toBuyThings) {
        this.toBuyThings = toBuyThings;
    }
    public String getInvestigatePerson() {
        return investigatePerson;
    }

    public void setInvestigatePerson(String investigatePerson) {
        this.investigatePerson = investigatePerson;
    }
    public Date getInvestigateDate() {
        return investigateDate;
    }

    public void setInvestigateDate(Date investigateDate) {
        this.investigateDate = investigateDate;
    }
    
     public List<SupplierBankVO> getSupplierBankList() {
        return supplierBankList;
     }

     public void setSupplierBankList(List<SupplierBankVO> supplierBankList) {
        this.supplierBankList = supplierBankList;
     }
     public List<SupplierCertVO> getSupplierCertList() {
        return supplierCertList;
     }

     public void setSupplierCertList(List<SupplierCertVO> supplierCertList) {
        this.supplierCertList = supplierCertList;
     }

    public Boolean getGroupBlack() {
        return groupBlack;
    }

    public void setGroupBlack(Boolean groupBlack) {
        this.groupBlack = groupBlack;
    }

    public Date getGroupLastTime() {
        return groupLastTime;
    }

    public void setGroupLastTime(Date groupLastTime) {
        this.groupLastTime = groupLastTime;
    }

    public String getBlackOrgIds() {
        return blackOrgIds;
    }

    public void setBlackOrgIds(String blackOrgIds) {
        this.blackOrgIds = blackOrgIds;
    }

    public String getBlackOrgNames() {
        return blackOrgNames;
    }

    public void setBlackOrgNames(String blackOrgNames) {
        this.blackOrgNames = blackOrgNames;
    }

    public BigDecimal getYearScore() {
        return yearScore;
    }

    public void setYearScore(BigDecimal yearScore) {
        this.yearScore = yearScore;
    }
}
