package com.ejianc.foundation.support.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

/**
 * 单据编码规则子元素
 */
public class BillCodeRuleAttrVO extends BaseVO {
	private static final long serialVersionUID = 1789655300682048249L;

	/**
	 * 元素类型-流水号
	 */
	public static final String ELEM_TYPE_SN = "0";
	/**
	 * 元素类型-常量
	 */
	public static final String ELEM_TYPE_CONSTANT = "1";
	/**
	 * 元素类型-时间
	 */
	public static final String ELEM_TYPE_TIME = "2";
	/**
	 * 元素类型-随机字符串
	 */
	public static final String ELEM_TYPE_RANDOM_STR = "3";
	/**
	 * 元素类型-实体属性值
	 */
	public static final String ELEM_TYPE_ENTITY_ATTR = "4";
	/**
	 * 元素类型-自定义流水依据
	 */
	public static final String ELEM_TYPE_CUSTOM_SN = "5";

	/**
	 * 流水依据-时间-非流水依据
	 */
	public static final String ELEM_ISREFER_TIME_NOT_SN = "0";
	/**
	 * 流水依据-时间-依据年度
	 */
	public static final String ELEM_ISREFER_TIME_YEAR = "1";

	/**
	 * 流水依据-时间-依据月度
	 */
	public static final String ELEM_ISREFER_TIME_MONTH = "2";

	/**
	 * 流水依据-时间-依据每日
	 */
	public static final String ELEM_ISREFER_TIME_DAY = "3";

	/**
	 * 流水依据-其他-非流水依据
	 */
	public static final String ELEM_ISREFER_OTHER_SN = "0";

	/**
	 * 流水依据-其他-是流水依据
	 */
	public static final String ELEM_ISREFER_OTHER_NOT_SN = "1";

	/**
	 * 段号
	 */
	private int elemOrder;
	/**
	 * 元素类型： {'0':'流水号', '1':'常量', '2':'时间', '3': '随机字符串', '4': '实体属性值', '5':
	 * '自定义流水依据'}
	 *
	 */
	private String elemType;
	/**
	 * 流水依据 元素类型为时间时：{0': '非流水依据' '1': '是,依据年度', '2':'是,依据月度', '3':'是,依据每日'}
	 * 其他：{'0':'非流水依据', '1':'是流水依据'}
	 */
	private String elemIsRefer;
	/**
	 * 元素长度
	 */
	private int elemLength;
	/**
	 * 元素值
	 */
	private String elemValue;

	private String billValue;

	/**
	 * 单据编码规则ID
	 */
	private Long billCodeRuleId;

	/**
	 * 日期格式数据格式化方式
	 */
	private String dateElemDisplayFormat;

	/**
	 * 填充方式
	 */
	private int fillStyle;

	/**
	 * 填充内容
	 */
	private String fillSign;

	public static final String DATEFORMAT_YY = "yy";
	public static final String DATEFORMAT_YYYY = "yyyy";
	public static final String DATEFORMAT_YYMM = "yyMM";
	public static final String DATEFORMAT_YYYYMM = "yyyyMM";
	public static final String DATEFORMAT_YYMMDD = "yyMMdd";
	public static final String DATEFORMAT_YYYYMMDD = "yyyyMMdd";

	public int getElemOrder() {
		return elemOrder;
	}

	public void setElemOrder(int elemOrder) {
		this.elemOrder = elemOrder;
	}

	public String getElemType() {
		return elemType;
	}

	public void setElemType(String elemType) {
		this.elemType = elemType;
	}

	public String getElemIsRefer() {
		return elemIsRefer;
	}

	public void setElemIsRefer(String elemIsRefer) {
		this.elemIsRefer = elemIsRefer;
	}

	public int getElemLength() {
		return elemLength;
	}

	public void setElemLength(int elemLength) {
		this.elemLength = elemLength;
	}

	public String getElemValue() {
		return elemValue;
	}

	public void setElemValue(String elemValue) {
		this.elemValue = elemValue;
	}

	public Long getBillCodeRuleId() {
		return billCodeRuleId;
	}

	public void setBillCodeRuleId(Long billCodeRuleId) {
		this.billCodeRuleId = billCodeRuleId;
	}

	public String getDateElemDisplayFormat() {
		return dateElemDisplayFormat;
	}

	public void setDateElemDisplayFormat(String dateElemDisplayFormat) {
		this.dateElemDisplayFormat = dateElemDisplayFormat;
	}

	public int getFillStyle() {
		return fillStyle;
	}

	public void setFillStyle(int fillStyle) {
		this.fillStyle = fillStyle;
	}

	public String getFillSign() {
		return fillSign;
	}

	public void setFillSign(String fillSign) {
		this.fillSign = fillSign;
	}

	public String getBillValue() {
		return billValue;
	}

	public void setBillValue(String billValue) {
		this.billValue = billValue;
	}

}
