package com.ejianc.foundation.dataModel.api;

import com.ejianc.foundation.initData.hystrix.InitDataHystrix;
import com.ejianc.foundation.initData.vo.EnterpriseInitVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author mrsir_wxp
 * @Date 2022年5月26日 用于数据模型查询相关操作
 * @Description
 */
@FeignClient(name= "ejc-support-web", url="${common.env.feign-client-url}", path="ejc-support-web", fallback = InitDataHystrix.class)
public interface IDataModelApi {

    @PostMapping(value = "/api/dataModelApi/initData")
    void initData(@RequestBody EnterpriseInitVO vo);

}
