package com.ejianc.foundation.initData.api;

import com.ejianc.foundation.initData.hystrix.InitDataHystrix;
import com.ejianc.foundation.initData.vo.EnterpriseInitVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author mrsir_wxp
 * @Date 2020/7/7 用于租户审核通过之后生成租户的物资设备表，自定义档案表，以及回滚等操作
 * @Description InitDataApi
 */
@FeignClient(name= "ejc-support-web", url="${common.env.feign-client-url}", path="ejc-support-web", fallback = InitDataHystrix.class)
public interface InitDataApi {

    @PostMapping(value = "/api/initDataApi/initData")
    void initData(@RequestBody EnterpriseInitVO vo);

    @PostMapping(value = "/api/initDataApi/rollBack")
    void rollBack(@RequestParam("tenantId") Long tenantId);

    @PostMapping(value = "/api/initDataApi/initDataByParams")
    void initDataByParams(@RequestBody EnterpriseInitVO vo);

    //根据参数删除租户级物料分类、物料明细、自定义档案三个表结构，回滚
    //all(所有)，supplier（供方数据初始化）,customer(客户初始化),material(物资、设备表创建),def(自定义档案)
    @PostMapping(value = "/api/initDataApi/rollBackByParams")
    void rollBackByParams(@RequestBody EnterpriseInitVO vo);
}
