package com.ejianc.foundation.support.api;

import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.support.hystrix.BillTypeHystrix;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.foundation.support.vo.QuoteParamsVO;
import com.ejianc.framework.core.response.CommonResponse;

import java.util.List;
import java.util.Map;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 自动编码获取rpc服务
 * 
 * @author cJ
 *
 */
@FeignClient(name= "ejc-support-web", url="${common.env.feign-client-url}", path="ejc-support-web", fallback = BillTypeHystrix.class)
public interface IBillTypeApi {

	/**
	 * 根据单据编码获取单据信息
	 *
	 * @param code
	 * @return
	 */
	@GetMapping(value = "/api/billTypeApi/getByCode")
	public CommonResponse<BillTypeVO> getByCode(@RequestParam(value = "code") String code);

	/**
	 * 根据单据类型Id查询单据类型信息
	 *
	 * @param id
	 * @return
	 */
	@GetMapping(value = "/api/billTypeApi/getById")
	public CommonResponse<BillTypeVO> getById(@RequestParam(value = "id") Long id);

	/**
	 * 根据billType查询详情
	 * 
	 * @param refCode
	 * @return
	 */
	@RequestMapping(value = "/api/billTypeApi/queryMetadataByBillType", method=RequestMethod.GET)
	public CommonResponse<MdReferVO> queryMetadataByBillType(@RequestParam(value="billTypeCode", required=true) String billTypeCode);

	/**
	 * 根据单据编码引用检查
	 *
	 * @param code
	 * @return
	 */
	@GetMapping(value = "/api/billTypeApi/checkQuote")
	public CommonResponse<String> checkQuote(@RequestParam(value = "billTypeCode") String billTypeCode,@RequestParam(value = "billId") Long billId);

	/**
	 * 根据单据编码引用检查
	 *
	 * @param billTypeCode
	 * @param billIds
	 * @return
	 */
	@GetMapping(value = "/api/billTypeApi/checkQuotes")
	public CommonResponse<Map<String, String>> checkQuotes(@RequestParam(value = "billTypeCode") String billTypeCode, @RequestParam(value = "billIds") List<Long> billIds);

	/**
	 * @description:  根据单据编码引用检查并返回引用的单据ids
	 *
	 * QuoteParamsVO
	 * @return {@link CommonResponse< List< Long>>} 返回引用的单据ids
	 * @author songlx
	 * @date: 2024/5/15
	 */
	@PostMapping(value = "/api/billTypeApi/checkQuotesAndReturnQuoteBillIds")
	CommonResponse<List<Long>> checkQuotesAndReturnQuoteBillIds(@RequestBody QuoteParamsVO params);


	/**
	 * 根据实体refCode查询对应单据类型
	 *
	 * @param refCode
	 * @return
	 */
	@GetMapping(value = "api/billTypeApi/getByRefCode")
	public CommonResponse<BillTypeVO> getByRefCode(@RequestParam(value = "refCode") String refCode);
	
	/**
	 * 根据模块Id查询单据类型列表
	 * 
	 * @param moduleId
	 * @return
	 */
	@GetMapping(value = "api/billTypeApi/queryBillTypeByModuleId")
	public CommonResponse<List<BillTypeVO>> queryBillTypeByModuleId(@RequestParam(value = "moduleId") Long moduleId);

	/**
	 * 根据模块Id查询模块(本下)下的所有单据类型
	 *
	 * @param moduleId
	 * @return
	 */
	@GetMapping(value = "api/billTypeApi/queryAllBillTypeByModuleId")
	public CommonResponse<List<BillTypeVO>> queryAllBillTypeByModuleId(@RequestParam(value = "moduleId") Long moduleId);
}
