/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialFuzzyMatchVO;
import com.ejianc.foundation.share.vo.MaterialPlusVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/materialApi/"})
public class MaterialApi {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IMaterialCategoryService materialCategoryService;

    @PostMapping(value={"queryExitFlag"})
    public CommonResponse<MaterialVO> queryExitFlag(@RequestBody MaterialVO materialVO) {
        this.logger.info("\u8c03\u7528queryExitFlag {}", (Object)JSONObject.toJSONString((Object)materialVO));
        MaterialVO vo = this.materialService.queryExitFlag(materialVO.getName(), materialVO.getSpec(), materialVO.getUnitName(), materialVO.getCategoryId());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"queryCategoryByCode"})
    public CommonResponse<MaterialCategoryVO> queryCategoryByCode(@RequestParam(value="code") String code) {
        List<MaterialCategoryEntity> list = this.materialCategoryService.queryByCode(String.valueOf(code));
        MaterialCategoryVO vo = null;
        if (ListUtil.isNotEmpty(list)) {
            vo = (MaterialCategoryVO)BeanMapper.map((Object)list.get(0), MaterialCategoryVO.class);
        }
        if (vo == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u7f16\u7801\u6240\u5c5e\u5206\u7c7b\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vo);
    }

    @GetMapping(value={"queryCategoryListByPid"})
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByPid(@RequestParam(value="id") Long id) {
        List<MaterialCategoryVO> list = this.materialCategoryService.queryListByPid(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @GetMapping(value={"queryCategoryListByChildren"})
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByChildren(@RequestParam(value="ids") List<Long> ids) {
        List<MaterialCategoryVO> list = this.materialCategoryService.queryCategoryListByChildren(ids);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @GetMapping(value={"queryMaterialBySourceId"})
    public CommonResponse<MaterialVO> queryMaterialBySourceId(String sourceId) {
        MaterialEntity entity = this.materialService.queryBySourceId(sourceId);
        if (entity != null) {
            return CommonResponse.success((Object)BeanMapper.map((Object)entity, MaterialVO.class));
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u672a\u67e5\u5230\u76f8\u5173\u7269\u8d44\u3002");
    }

    @GetMapping(value={"queryMaterialByIds"})
    CommonResponse<List<MaterialVO>> queryMaterialByIds(@RequestParam(value="ids") List<Long> ids) {
        List<MaterialEntity> entitys = this.materialService.queryMaterialByIds(ids);
        if (entitys != null && entitys.size() > 0) {
            return CommonResponse.success((Object)BeanMapper.mapList(entitys, MaterialVO.class));
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u672a\u67e5\u5230\u76f8\u5173\u7269\u8d44\u3002");
    }

    @GetMapping(value={"queryCategoryById"})
    public CommonResponse<MaterialCategoryVO> queryCategoryById(@RequestParam(value="id") Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.materialCategoryService.queryDetail(id));
    }

    @PostMapping(value={"/api/materialApi/queryCategorysByNames"})
    public CommonResponse<List<MaterialCategoryVO>> queryCategorysByNames(@RequestBody List<String> nameList) {
        List<MaterialCategoryVO> entitys = this.materialCategoryService.queryCategorysByNames(nameList);
        return CommonResponse.success(entitys);
    }

    @PostMapping(value={"queryListByInnerCode"})
    public CommonResponse<List<MaterialCategoryVO>> queryListByInnerCode(@RequestBody Map<String, Object> params) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", this.materialCategoryService.queryListByInnerCodes(params));
    }

    @GetMapping(value={"queryMaterialListByNames"})
    public CommonResponse<List<MaterialVO>> queryMaterialListByNames(@RequestParam(value="nameList") List<String> nameList) {
        List<MaterialEntity> entitys = this.materialService.queryMaterialListByNames(nameList);
        if (entitys != null && entitys.size() > 0) {
            return CommonResponse.success((Object)BeanMapper.mapList(entitys, MaterialVO.class));
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u672a\u67e5\u5230\u76f8\u5173\u7269\u8d44\u3002");
    }

    @PostMapping(value={"queryMaterialsByNames"})
    @ResponseBody
    public CommonResponse<List<MaterialVO>> queryMaterialsByNames(@RequestBody List<String> nameList) {
        List<MaterialEntity> entitys = this.materialService.queryMaterialListByNames(nameList);
        if (entitys != null && entitys.size() > 0) {
            return CommonResponse.success((Object)BeanMapper.mapList(entitys, MaterialVO.class));
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u672a\u67e5\u5230\u76f8\u5173\u7269\u8d44\u3002");
    }

    @RequestMapping(value={"/queryMaterialList"}, method={RequestMethod.POST})
    public CommonResponse<List<MaterialVO>> queryMaterialList(@RequestBody MaterialVO materialVO) {
        this.logger.info("\u8c03\u7528queryMaterialList {}", (Object)JSONObject.toJSONString((Object)materialVO));
        List<MaterialVO> list = this.materialService.queryMaterialList(materialVO.getName(), materialVO.getSpec(), materialVO.getUnitName());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @PostMapping(value={"/checkArchive"})
    public CommonResponse<MaterialFuzzyMatchVO> checkArchive(@RequestBody MaterialFuzzyMatchVO materialFuzzyMatchVO) {
        return CommonResponse.success((String)"\u6821\u9a8c\u6863\u6848\u662f\u5426\u5b58\u5728\u6210\u529f\uff01", (Object)this.materialService.checkArchive(materialFuzzyMatchVO));
    }

    @PostMapping(value={"/fuzzyMatchNumber"})
    public CommonResponse<MaterialFuzzyMatchVO> fuzzyMatchNumber(@RequestBody MaterialFuzzyMatchVO materialFuzzyMatchVO) {
        return CommonResponse.success((String)"\u6a21\u7cca\u5339\u914d\u6570\u91cf\u6210\u529f\uff01", (Object)this.materialService.fuzzyMatchNumber(materialFuzzyMatchVO));
    }

    @PostMapping(value={"/fuzzyMatchQueryPage"})
    public CommonResponse<IPage<MaterialPlusVO>> fuzzyMatchQueryPage(@RequestBody MaterialFuzzyMatchVO materialFuzzyMatchVO) {
        return CommonResponse.success((String)"\u6a21\u7cca\u5339\u914d\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01", this.materialService.fuzzyMatchQueryPage(materialFuzzyMatchVO.getCurrent(), materialFuzzyMatchVO.getSize(), materialFuzzyMatchVO.getName(), materialFuzzyMatchVO.getType(), materialFuzzyMatchVO.getCategoryName(), materialFuzzyMatchVO.getSpec(), materialFuzzyMatchVO.getUnitName(), materialFuzzyMatchVO.getFuzzyName(), materialFuzzyMatchVO.getFuzzySpec(), materialFuzzyMatchVO.getFuzzyUnitName()));
    }

    @PostMapping(value={"/batchInsertArchive"})
    public CommonResponse<Map<String, MaterialVO>> batchInsertArchive(@RequestBody Map<String, MaterialVO> materialVOMap) throws BillCodeException {
        return this.materialService.batchInsertArchive(materialVOMap);
    }

    @PostMapping(value={"queryMaterialsByCodes"})
    @ResponseBody
    public CommonResponse<List<MaterialVO>> queryMaterialsByCodes(@RequestBody List<String> codeList) {
        List<MaterialEntity> entitys = this.materialService.queryMaterialListByCodes(codeList);
        if (entitys != null && entitys.size() > 0) {
            return CommonResponse.success((Object)BeanMapper.mapList(entitys, MaterialVO.class));
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u672a\u67e5\u5230\u76f8\u5173\u7269\u8d44\u3002");
    }
}

