/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.bean.CustomerCategoryEntity;
import com.ejianc.foundation.share.bean.CustomerEntity;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ICustomerCategoryService;
import com.ejianc.foundation.share.service.ICustomerService;
import com.ejianc.foundation.share.service.ISupplierCategoryService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/zatop/mdm/"})
public class ZatopMdmController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISupplierCategoryService supplierCategoryService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private ICustomerCategoryService customerCategoryService;
    @Autowired
    private ICustomerService customerService;
    @Value(value="${zatop.cn.url:http://md.zatop.cn/service/datapub}")
    private String zatopMdmUrl;
    @Value(value="${zatop.cn.appKey:web}")
    private String appKey;
    @Value(value="${zatop.cn.appSecret:web}")
    private String appSecret;
    private static Map<String, String> header = null;

    @GetMapping(value={"/innerSupplierAndCustomer/sync"})
    @ResponseBody
    public String syncInnerSupplierAndCustomer() {
        String host = this.zatopMdmUrl + "/rest/api/v1/hcm/legalcompList";
        JSONObject params = new JSONObject();
        try {
            Integer pageNum = 1;
            params.put("dver_type", (Object)2);
            params.put("pageNum", (Object)pageNum);
            params.put("pageSize", (Object)100);
            boolean has = true;
            while (has) {
                String resStr = HttpTookit.postByJson((String)host, (String)params.toJSONString(), this.getHeader(), (Integer)50, (Integer)50);
                if (StringUtils.isEmpty((CharSequence)resStr)) {
                    this.logger.info("\u5357\u660c\u4e2d\u5965\uff0c\u6cd5\u4eba\u7ec4\u7ec7\u540c\u6b65\uff0cwhile\u8bf7\u6c42--{}\uff0c\u53c2\u6570--{}\uff0c\u54cd\u5e94\u4e3a\u7a7a\uff01", (Object)host, (Object)JSONObject.toJSONString((Object)params));
                    has = false;
                    continue;
                }
                JSONObject resJson = JSONObject.parseObject((String)resStr);
                if (resJson.getInteger("code") == 2000) {
                    JSONObject data = resJson.getJSONObject("data");
                    Integer pages = data.getInteger("pages");
                    JSONArray content = data.getJSONArray("content");
                    if (pageNum >= pages) {
                        has = false;
                    } else {
                        Integer n = pageNum;
                        Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
                        params.put("pageNum", (Object)pageNum);
                    }
                    this.saveOrUpdateSupplierAndCustomer(content);
                    continue;
                }
                has = false;
                this.logger.info("\u5357\u660c\u4e2d\u5965\uff0c\u6cd5\u4eba\u7ec4\u7ec7\u540c\u6b65\uff0cwhile\u8bf7\u6c42--{}\uff0c\u53c2\u6570--{}\uff0c\u54cd\u5e94\u5931\u8d25--{}", new Object[]{host, JSONObject.toJSONString((Object)params), resStr});
            }
        }
        catch (Exception e) {
            this.logger.info("\u5357\u660c\u4e2d\u5965\uff0c\u6cd5\u4eba\u7ec4\u7ec7\u540c\u6b65\uff0c\u8bf7\u6c42--{},\u53c2\u6570--{}\uff0c\u51fa\u9519--{}", new Object[]{host, params.toJSONString(), e.getMessage()});
        }
        return "\u540c\u6b65\u6210\u529f\uff01";
    }

    private void saveOrUpdateSupplierAndCustomer(JSONArray positionArr) {
        if (positionArr != null && positionArr.size() > 0) {
            CustomerCategoryEntity customerCategoryEntity;
            SupplierCategoryEntity supplierCategoryEntity;
            QueryParam param = new QueryParam();
            param.getParams().put("code", new Parameter("eq", (Object)"Inner-Supplier"));
            param.getParams().put("tenantId", new Parameter("eq", (Object)888888L));
            List supplierCategoryEntities = this.supplierCategoryService.queryList(param, false);
            if (ListUtil.isEmpty((List)supplierCategoryEntities)) {
                supplierCategoryEntity = new SupplierCategoryEntity();
                supplierCategoryEntity.setId(IdWorker.getId());
                supplierCategoryEntity.setCode("Inner-Supplier");
                supplierCategoryEntity.setTenantId(888888L);
                supplierCategoryEntity.setDescription("\u5185\u90e8\u4f9b\u5e94\u5546\u5206\u7c7b\uff0c\u7cfb\u7edf\u81ea\u52a8\u751f\u6210\uff01");
                supplierCategoryEntity.setName("\u5185\u90e8\u4f9b\u5e94\u5546");
                supplierCategoryEntity.setInnerCode(supplierCategoryEntity.getId().toString());
                supplierCategoryEntity.setSequence(0);
                this.supplierCategoryService.saveOrUpdate((Object)supplierCategoryEntity);
            } else {
                supplierCategoryEntity = (SupplierCategoryEntity)((Object)supplierCategoryEntities.get(0));
            }
            param.getParams().put("code", new Parameter("eq", (Object)"Inner-Customer"));
            List customerCategoryEntities = this.customerCategoryService.queryList(param, false);
            if (ListUtil.isEmpty((List)customerCategoryEntities)) {
                customerCategoryEntity = new CustomerCategoryEntity();
                customerCategoryEntity.setId(IdWorker.getId());
                customerCategoryEntity.setCode("Inner-Customer");
                customerCategoryEntity.setTenantId(888888L);
                customerCategoryEntity.setDescription("\u5185\u90e8\u5ba2\u6237\u5206\u7c7b\uff0c\u7cfb\u7edf\u81ea\u52a8\u751f\u6210\uff01");
                customerCategoryEntity.setName("\u5185\u90e8\u5ba2\u6237");
                customerCategoryEntity.setInnerCode(supplierCategoryEntity.getId().toString());
                customerCategoryEntity.setSequence(0);
                this.customerCategoryService.saveOrUpdate((Object)customerCategoryEntity);
            } else {
                customerCategoryEntity = (CustomerCategoryEntity)((Object)customerCategoryEntities.get(0));
            }
            for (Object o : positionArr) {
                CustomerEntity customerEntity;
                SupplierEntity supplierEntity;
                JSONObject object = (JSONObject)o;
                param = new QueryParam();
                param.getParams().put("sourceId", new Parameter("eq", (Object)object.getString("id")));
                List supplierEntities = this.supplierService.queryList(param, false);
                if (ListUtil.isEmpty((List)supplierEntities)) {
                    supplierEntity = new SupplierEntity();
                    supplierEntity.setTenantId(888888L);
                    supplierEntity.setSourceId(object.getString("id"));
                    supplierEntity.setCategoryId(supplierCategoryEntity.getId());
                    supplierEntity.setName(object.getString("legalorg_name"));
                    supplierEntity.setCode(object.getString("legalorg_code"));
                    supplierEntity.setCategoryName(supplierCategoryEntity.getName());
                    supplierEntity.setSocialCreditCode(object.getString("unified_social_credit_code"));
                    supplierEntity.setLegal(object.getString("current_legal_representative"));
                    supplierEntity.setBusinessScope(object.getString("business_scope"));
                    supplierEntity.setEnabled(object.getInteger("data_status") == 0 ? 1 : 0);
                    supplierEntity.setDescription("\u4e3b\u6570\u636e\u540c\u6b65\u751f\u6210\uff01");
                } else {
                    supplierEntity = (SupplierEntity)((Object)supplierEntities.get(0));
                    supplierEntity.setName(object.getString("legalorg_name"));
                    supplierEntity.setCode(object.getString("legalorg_code"));
                    supplierEntity.setSocialCreditCode(object.getString("unified_social_credit_code"));
                    supplierEntity.setLegal(object.getString("current_legal_representative"));
                    supplierEntity.setBusinessScope(object.getString("business_scope"));
                    supplierEntity.setEnabled(object.getInteger("data_status") == 0 ? 1 : 0);
                }
                this.supplierService.saveOrUpdate((Object)supplierEntity, false);
                List customerEntities = this.customerService.queryList(param, false);
                if (ListUtil.isEmpty((List)customerEntities)) {
                    customerEntity = new CustomerEntity();
                    customerEntity.setTenantId(888888L);
                    customerEntity.setCategoryId(customerCategoryEntity.getId());
                    customerEntity.setSourceId(object.getString("id"));
                    customerEntity.setName(object.getString("legalorg_name"));
                    customerEntity.setCode(object.getString("legalorg_code"));
                    customerEntity.setCategoryName(customerCategoryEntity.getName());
                    customerEntity.setSocialCreditCode(object.getString("unified_social_credit_code"));
                    customerEntity.setLegal(object.getString("current_legal_representative"));
                    customerEntity.setDescription("\u4e3b\u6570\u636e\u540c\u6b65\u751f\u6210\uff01");
                } else {
                    customerEntity = (CustomerEntity)((Object)customerEntities.get(0));
                    customerEntity.setName(object.getString("legalorg_name"));
                    customerEntity.setCode(object.getString("legalorg_code"));
                    customerEntity.setSocialCreditCode(object.getString("unified_social_credit_code"));
                    customerEntity.setLegal(object.getString("current_legal_representative"));
                }
                this.customerService.saveOrUpdate((Object)customerEntity, false);
            }
        }
    }

    private synchronized Map<String, String> getHeader() {
        if (header == null) {
            header = new HashMap<String, String>();
            header.put("appKey", this.appKey);
            header.put("appSecret", this.appSecret);
        }
        return header;
    }
}

