/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller;

import com.ejianc.foundation.support.service.IDataTransferService;
import com.ejianc.framework.core.response.CommonResponse;
import java.sql.BatchUpdateException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"dataTransfer"})
public class DataTransferController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataTransferController.class);
    @Autowired
    private IDataTransferService service;

    @ResponseBody
    @RequestMapping(value={"transferBySql"})
    public CommonResponse<String> transferBySql(@RequestBody Map<String, Object> params) {
        try {
            if (params == null || params.isEmpty() || params.get("sql") == null) {
                return CommonResponse.error((String)"\u53d1\u5e03\u6570\u636e\u5931\u8d25:\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570!");
            }
            List sqls = (List)params.get("sql");
            if (sqls != null && sqls.size() > 0) {
                return this.service.executeSql(sqls);
            }
        }
        catch (DuplicateKeyException dke) {
            String errorMsg = dke.getMessage();
            if (dke.getCause() != null) {
                LOGGER.error(dke.getMessage(), dke.getCause());
                BatchUpdateException bue = (BatchUpdateException)dke.getCause();
                if ("23000".equalsIgnoreCase(bue.getSQLState())) {
                    String msg = bue.getMessage();
                    String code = msg.substring(msg.indexOf("'") + 1, msg.indexOf("for") - 2);
                    if (StringUtils.isNotBlank((CharSequence)code) && code.contains("-")) {
                        code = code.substring(0, code.lastIndexOf("-"));
                    }
                    errorMsg = "\u76ee\u6807\u73af\u5883\u5df2\u5b58\u5728\u7f16\u53f7\u4e3a[" + code + "]\u7684\u6570\u636e";
                }
            }
            return CommonResponse.error((String)("\u53d1\u5e03\u6570\u636e\u5931\u8d25:" + errorMsg));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(e.getMessage(), e.getCause());
            return CommonResponse.error((String)("\u53d1\u5e03\u6570\u636e\u5931\u8d25:" + e.getMessage()));
        }
        return CommonResponse.success((String)"\u53d1\u5e03\u6570\u636e\u6210\u529f");
    }
}

