package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.bean.BrandEntity;
import com.ejianc.foundation.share.service.IBrandService;
import com.ejianc.foundation.share.vo.BrandVO;
import com.ejianc.foundation.support.service.IBillTypeService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 品牌库
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("brand")
public class BrandController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IBrandService service;

    @Autowired
    private IBillTypeService billTypeService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BrandVO> saveOrUpdate(@RequestBody BrandVO saveOrUpdateVO) {
    	BrandEntity entity = BeanMapper.map(saveOrUpdateVO, BrandEntity.class);
    	service.saveOrUpdate(entity, false);
    	BrandVO vo = BeanMapper.map(entity, BrandVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BrandVO> queryDetail(Long id) {
    	BrandEntity entity = service.selectById(id);
    	BrandVO vo = BeanMapper.map(entity, BrandVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BrandVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (BrandVO vo : vos) {
                CommonResponse<String> resp = billTypeService.checkQuote("BT240524000000002", vo.getId());
                if (!resp.isSuccess()) {
                    return CommonResponse.error("删除失败！" + resp.getMsg());
                }
            }
        }
        service.removeByIds(vos.stream().map(BrandVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BrandVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("brandCode");
        fuzzyFields.add("brandName");
        fuzzyFields.add("memo");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<BrandEntity> page = service.queryPage(param,false);
        IPage<BrandVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BrandVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("brandCode");
        fuzzyFields.add("brandName");
        fuzzyFields.add("memo");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        List<BrandEntity> list = service.queryList(param);
        List<BrandVO> brandVOS = BeanMapper.mapList(list, BrandVO.class);
        for (BrandVO vo : brandVOS) {
            switch (vo.getState()){
                case 0:
                    vo.setStateName("停用");
                    break;
                case 1:
                    vo.setStateName("启用");
                    break;
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", brandVOS);
        ExcelExport.getInstance().export("Brand-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refBrandData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BrandVO>> refBrandData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().addAll(Arrays.asList("brandCode","brandName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("state", new Parameter(QueryParam.EQ, 1));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BrandEntity> page = service.queryPage(param,false);
        IPage<BrandVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BrandVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * 导入模板下载
     */
    @RequestMapping(value = "/downloadTemplet")
    @ResponseBody
    public void downloadTemplet(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "Brand-import.xlsx", "导入品牌库");
    }

    /**
     * 导入校验
     *
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<BrandVO> successList = new ArrayList<>();
            List<BrandVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 3) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
            }

            for (int i = 0; i < result.size(); i++) {
                List<String> row = result.get(i);
                StringBuilder errMsg = new StringBuilder();
                BrandVO brandVO = new BrandVO();
                //品牌编码
                String brandCode = row.get(0).trim();
                if (StringUtils.isNotBlank(brandCode)){
                    brandVO.setBrandCode(brandCode);
                    LambdaQueryWrapper<BrandEntity> brandLambdaQueryWrapper = Wrappers.lambdaQuery();
                    brandLambdaQueryWrapper.eq(BrandEntity::getTenantId,InvocationInfoProxy.getTenantid());
                    brandLambdaQueryWrapper.eq(BrandEntity::getBrandCode,brandCode);
                    int count = service.count(brandLambdaQueryWrapper);
                    if (count > 0){
                        errMsg.append("编码重复");
                    }
                }else {
                    errMsg.append("品牌编码未填写" );
                }
                //品牌名称
                String brandName = row.get(1).trim();
                if (StringUtils.isNotBlank(brandName)){
                    brandVO.setBrandName(brandName);
                }else {
                    errMsg.append("品牌名称未填写" );
                }
                //描述
                String memo = row.get(2).trim();
                brandVO.setMemo(memo);
                brandVO.setState(1);
                brandVO.setStateName("已启用");
                brandVO.setErrMsg(errMsg.toString());
                if (StringUtils.isNotBlank(brandVO.getErrMsg())) {
                    errorList.add(brandVO);
                } else {
                    successList.add(brandVO);
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", BeanMapper.mapList(successList, BrandVO.class));
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    /**
     * @description: 保存导入
     */
    @RequestMapping(value = "/saveImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImport(@RequestBody List<BrandVO> accbookVOS) {
//        Long tenantId = InvocationInfoProxy.getTenantid();
//        CommonResponse<List<String>> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId, accbookVOS.size());
//        List<String> billCodeList = new ArrayList<>();
//        if (billCode.isSuccess()) {
//            billCodeList = billCode.getData();
//        } else {
//            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//        }
//        for (int i = 0; i < accbookVOS.size(); i++) {
//            accbookVOS.get(i).setBillCode(billCodeList.get(i));
//        }
//        logger.info("billcode----------------："+ JSONObject.toJSONString(billCode));
        service.saveBatch(BeanMapper.mapList(accbookVOS, BrandEntity.class));
        return CommonResponse.success("导入成功");
    }



}
